/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.eventstream.UntypedRecordableEventDescriptor;
import org.xwiki.eventstream.internal.DefaultUntypedRecordableEvent;
import org.xwiki.eventstream.internal.ModelBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.AllEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
@Named(value="Untyped Event Listener")
public class UntypedEventListener
extends AbstractEventListener {
    public static final String NAME = "Untyped Event Listener";
    public static final String EVENT_BINDING_NAME = "event";
    public static final String SOURCE_BINDING_NAME = "source";
    private static final String EVENT_STREAM_MODULE = "org.xwiki.platform:xwiki-platform-eventstream-api";
    private static final String XRETURN_BINDING = "xreturn";
    @Inject
    private ObservationManager observationManager;
    @Inject
    private TemplateManager templateManager;
    @Inject
    @Named(value="html/5.0")
    private BlockRenderer renderer;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private ModelBridge modelBridge;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private EntityReferenceSerializer<String> entitySerializer;
    @Inject
    private DocumentReferenceResolver<EntityReference> documentResolver;
    @Inject
    private Logger logger;

    public UntypedEventListener() {
        super(NAME, new Event[]{AllEvent.ALLEVENT});
    }

    public void onEvent(Event event, Object source, Object data) {
        try {
            List descriptors = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(UntypedRecordableEventDescriptor.class);
            for (UntypedRecordableEventDescriptor descriptor : descriptors) {
                if (!this.eventMatchesDescriptor(event, source, descriptor)) continue;
                Set<String> target = this.getTarget(event, source, descriptor);
                this.observationManager.notify((Event)new DefaultUntypedRecordableEvent(descriptor.getEventType(), target), (Object)EVENT_STREAM_MODULE, source);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Unable to retrieve a list of registered UntypedRecordableEventDescriptor from the ComponentManager.", (Throwable)e);
        }
    }

    private boolean eventMatchesDescriptor(Event event, Object source, UntypedRecordableEventDescriptor descriptor) {
        return descriptor.getEventTriggers().contains(event.getClass().getCanonicalName()) && this.checkXObjectCondition(descriptor, source) && this.isValidated(event, source, descriptor);
    }

    private boolean checkXObjectCondition(UntypedRecordableEventDescriptor descriptor, Object source) {
        return this.modelBridge.checkXObjectPresence(descriptor.getObjectTypes(), source);
    }

    private boolean isValidated(Event event, Object source, UntypedRecordableEventDescriptor descriptor) {
        try {
            String expression = descriptor.getValidationExpression();
            if (StringUtils.isBlank((CharSequence)expression)) {
                return true;
            }
            XDOM xdom = this.evaluateVelocity(event, source, expression, descriptor);
            Object xreturn = this.scriptContextManager.getCurrentScriptContext().getAttribute(XRETURN_BINDING);
            if (xreturn instanceof Boolean) {
                return (Boolean)xreturn;
            }
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.renderer.render((Block)xdom, (WikiPrinter)printer);
            String render = printer.toString().trim();
            return "true".equals(render);
        }
        catch (Exception e) {
            this.logger.warn("Unable to render a notification validation template.", (Throwable)e);
            return false;
        }
    }

    private Set<String> getTarget(Event event, Object source, UntypedRecordableEventDescriptor descriptor) {
        try {
            String expression = descriptor.getTargetExpression();
            if (StringUtils.isBlank((CharSequence)expression)) {
                return Collections.emptySet();
            }
            this.evaluateVelocity(event, source, expression, descriptor);
            Object xreturn = this.scriptContextManager.getCurrentScriptContext().getAttribute(XRETURN_BINDING);
            if (xreturn instanceof Iterable) {
                HashSet<String> target = new HashSet<String>();
                for (Object o : (Iterable)xreturn) {
                    if (!(o instanceof String)) continue;
                    target.add((String)o);
                }
                return target;
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to render the target template.", (Throwable)e);
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XDOM evaluateVelocity(Event event, Object source, String expression, UntypedRecordableEventDescriptor descriptor) throws Exception {
        ScriptContext currentScriptContext = this.scriptContextManager.getCurrentScriptContext();
        currentScriptContext.setAttribute(EVENT_BINDING_NAME, event, 100);
        currentScriptContext.setAttribute(SOURCE_BINDING_NAME, source, 100);
        try {
            DocumentReference documentReference;
            String templateName;
            EntityReference reference = descriptor.getEntityReference();
            if (reference != null) {
                templateName = (String)this.entitySerializer.serialize(reference, new Object[0]);
                documentReference = this.documentResolver.resolve((Object)reference, new Object[0]);
            } else {
                templateName = descriptor.toString();
                documentReference = null;
            }
            Template customTemplate = this.templateManager.createStringTemplate(templateName, expression, descriptor.getAuthorReference(), documentReference);
            XDOM xDOM = this.templateManager.execute(customTemplate);
            return xDOM;
        }
        finally {
            currentScriptContext.removeAttribute(EVENT_BINDING_NAME, 100);
            currentScriptContext.removeAttribute(SOURCE_BINDING_NAME, 100);
        }
    }
}

