/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.query;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.eventstream.EventQuery;
import org.xwiki.text.XWikiToStringBuilder;

public interface SortableEventQuery
extends EventQuery {
    public List<SortClause> getSorts();

    public static class SortClause {
        private final String property;
        private final boolean custom;
        private final Type customType;
        private final Order order;

        public SortClause(String property, Order order) {
            this(property, false, order);
        }

        public SortClause(String property, boolean custom, Order order) {
            this(property, custom, null, order);
        }

        public SortClause(String property, boolean custom, Type customType, Order order) {
            this.property = property;
            this.custom = custom;
            this.customType = customType;
            this.order = order;
        }

        public String getProperty() {
            return this.property;
        }

        @Deprecated(since="13.9RC1")
        public boolean isParameter() {
            return this.isCustom();
        }

        public boolean isCustom() {
            return this.custom;
        }

        public Type getCustomType() {
            return this.customType;
        }

        public Order getOrder() {
            return this.order;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.getProperty());
            builder.append(this.isCustom());
            builder.append((Object)this.getCustomType());
            builder.append((Object)this.getOrder());
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SortClause) {
                SortClause otherSortClause = (SortClause)obj;
                EqualsBuilder builder = new EqualsBuilder();
                builder.append((Object)this.getProperty(), (Object)otherSortClause.getProperty());
                builder.append(this.isCustom(), otherSortClause.isCustom());
                builder.append((Object)this.getCustomType(), (Object)otherSortClause.getCustomType());
                builder.append((Object)this.getOrder(), (Object)otherSortClause.getOrder());
                return builder.isEquals();
            }
            return false;
        }

        public String toString() {
            XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
            builder.append("property", (Object)this.getProperty());
            builder.append("custom", this.isCustom());
            builder.append("customType", (Object)this.getCustomType());
            builder.append("order", (Object)this.getOrder());
            return builder.build();
        }

        public static enum Order {
            DESC,
            ASC;

        }
    }
}

