/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.query;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.eventstream.query.CompareQueryCondition;
import org.xwiki.eventstream.query.GroupQueryCondition;
import org.xwiki.eventstream.query.InQueryCondition;
import org.xwiki.eventstream.query.MailEntityQueryCondition;
import org.xwiki.eventstream.query.PageableEventQuery;
import org.xwiki.eventstream.query.QueryCondition;
import org.xwiki.eventstream.query.SortableEventQuery;
import org.xwiki.eventstream.query.StatusQueryCondition;
import org.xwiki.text.XWikiToStringBuilder;

public class SimpleEventQuery
extends GroupQueryCondition
implements PageableEventQuery,
SortableEventQuery {
    private long limit = -1L;
    private long offset;
    private List<SortableEventQuery.SortClause> sorts = new ArrayList<SortableEventQuery.SortClause>();
    private boolean nextOr;
    private boolean nextReversed;
    private boolean nextCustom;
    private Type nextCustomType;
    private Deque<GroupQueryCondition> groupStack = new LinkedList<GroupQueryCondition>();

    public SimpleEventQuery() {
        super(false, false, new QueryCondition[0]);
    }

    public SimpleEventQuery(long offset, long limit) {
        this();
        this.setOffset(offset);
        this.setLimit(limit);
    }

    private GroupQueryCondition getCurrentGroupQueryCondition() {
        return this.groupStack.isEmpty() ? this : this.groupStack.peek();
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    public SimpleEventQuery setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public SimpleEventQuery setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public SimpleEventQuery not() {
        this.nextReversed = true;
        return this;
    }

    private QueryCondition getCurrentCondition() {
        GroupQueryCondition group = this.getCurrentGroupQueryCondition();
        return group.conditions.isEmpty() ? null : group.conditions.get(group.conditions.size() - 1);
    }

    public SimpleEventQuery or() {
        this.nextOr = true;
        return this;
    }

    public SimpleEventQuery and() {
        this.nextOr = false;
        return this;
    }

    private SimpleEventQuery beforeQueryCondition() {
        GroupQueryCondition currentGroup = this.getCurrentGroupQueryCondition();
        if (this.nextOr != currentGroup.isOr()) {
            if (currentGroup.conditions.size() <= 1) {
                currentGroup.or = this.nextOr;
            } else {
                QueryCondition currentCondition = this.getCurrentCondition();
                currentGroup.conditions.remove(currentGroup.conditions.size() - 1);
                this.open(this.nextOr, true, currentCondition);
            }
        }
        this.nextOr = false;
        return this;
    }

    @Deprecated(since="14.2RC1")
    public SimpleEventQuery parameter() {
        return this.custom();
    }

    public SimpleEventQuery custom() {
        this.nextCustom = true;
        return this;
    }

    public SimpleEventQuery custom(Type type) {
        this.nextCustom = true;
        this.nextCustomType = type;
        return this;
    }

    public SimpleEventQuery open() {
        this.beforeQueryCondition();
        this.open(false, false, new QueryCondition[0]);
        return this;
    }

    private void open(boolean or, boolean virtual, QueryCondition ... newConditions) {
        GroupQueryCondition group = new GroupQueryCondition(or, this.nextReversed, virtual, newConditions);
        GroupQueryCondition currentGroup = this.getCurrentGroupQueryCondition();
        currentGroup.conditions.add(group);
        this.groupStack.push(group);
        this.nextReversed = false;
    }

    public SimpleEventQuery close() {
        GroupQueryCondition closedGroup;
        do {
            closedGroup = this.groupStack.pop();
            GroupQueryCondition currentGroup = this.getCurrentGroupQueryCondition();
            if (closedGroup.getConditions().isEmpty()) {
                currentGroup.conditions.remove(currentGroup.conditions.size() - 1);
                continue;
            }
            if (closedGroup.getConditions().size() != 1 || !(closedGroup.getConditions().get(0) instanceof GroupQueryCondition)) continue;
            currentGroup.conditions.set(currentGroup.conditions.size() - 1, closedGroup.getConditions().get(0));
        } while (closedGroup.virtual);
        return this;
    }

    private void addCompareCondition(String property, Object value, CompareQueryCondition.CompareType type) {
        this.addCondition(new CompareQueryCondition(property, this.nextCustom, this.nextCustomType, value, type, this.nextReversed));
    }

    private void addCondition(QueryCondition newCondition) {
        this.beforeQueryCondition();
        GroupQueryCondition currentGroup = this.getCurrentGroupQueryCondition();
        currentGroup.conditions.add(newCondition);
        this.nextReversed = false;
        this.nextCustom = false;
        this.nextCustomType = null;
    }

    public SimpleEventQuery eq(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.EQUALS);
        return this;
    }

    public SimpleEventQuery less(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.LESS);
        return this;
    }

    public SimpleEventQuery lessOrEq(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.LESS_OR_EQUALS);
        return this;
    }

    public SimpleEventQuery greater(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.GREATER);
        return this;
    }

    public SimpleEventQuery greaterOrEq(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.GREATER_OR_EQUALS);
        return this;
    }

    public SimpleEventQuery startsWith(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.STARTS_WITH);
        return this;
    }

    public SimpleEventQuery endsWith(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.ENDS_WITH);
        return this;
    }

    public SimpleEventQuery contains(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.CONTAINS);
        return this;
    }

    public SimpleEventQuery before(Date date) {
        this.less("date", date);
        return this;
    }

    public SimpleEventQuery after(Date date) {
        this.greater("date", date);
        return this;
    }

    public SimpleEventQuery in(String property, List<?> values) {
        this.addCondition(new InQueryCondition(this.nextReversed, property, this.nextCustom, this.nextCustomType, values));
        return this;
    }

    public SimpleEventQuery in(String property, Object ... values) {
        return this.in(property, Arrays.asList(values));
    }

    public SimpleEventQuery withStatus(String entityId) {
        this.addCondition(new StatusQueryCondition(entityId, null, this.nextReversed));
        return this;
    }

    public SimpleEventQuery withStatus(String entityId, boolean read) {
        this.addCondition(new StatusQueryCondition(entityId, read, this.nextReversed));
        return this;
    }

    public SimpleEventQuery withStatus(boolean read) {
        this.addCondition(new StatusQueryCondition(null, read, this.nextReversed));
        return this;
    }

    public SimpleEventQuery withMail(String entityId) {
        this.addCondition(new MailEntityQueryCondition(entityId, this.nextReversed));
        return this;
    }

    @Override
    public List<SortableEventQuery.SortClause> getSorts() {
        return this.sorts;
    }

    public SimpleEventQuery addSort(String property, SortableEventQuery.SortClause.Order order) {
        this.sorts.add(new SortableEventQuery.SortClause(property, this.nextCustom, this.nextCustomType, order));
        this.nextCustom = false;
        this.nextCustomType = null;
        return this;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append(this.getLimit());
        builder.append(this.getOffset());
        builder.append(this.getSorts());
        return builder.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SimpleEventQuery) {
            SimpleEventQuery query = (SimpleEventQuery)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.appendSuper(super.equals(obj));
            builder.append(this.getLimit(), query.getLimit());
            builder.append(this.getOffset(), query.getOffset());
            builder.append(this.getSorts(), query.getSorts());
            return builder.build();
        }
        return false;
    }

    @Override
    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.appendSuper(super.toString());
        builder.append("limit", this.getLimit());
        builder.append("offset", this.getOffset());
        builder.append("sorts", this.getSorts());
        return builder.build();
    }
}

