/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.eventstream.EntityEvent;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventQuery;
import org.xwiki.eventstream.EventSearchResult;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.EventStreamConfiguration;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultEventStore
implements EventStore,
Initializable {
    private static final String GROUP_ID_CONTEXT_KEY = "activitystream_requestid";
    private static final String NO_STORE = "No event store available";
    @Inject
    private EventStreamConfiguration configuration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    private EventStore legacyStore;
    private EventStore store;

    public void initialize() throws InitializationException {
        String legacyHint;
        if (this.configuration.isEventStoreEnabled()) {
            String hint = this.configuration.getEventStore();
            if (this.componentManager.hasComponent(EventStore.class, hint)) {
                try {
                    this.store = (EventStore)this.componentManager.getInstance(EventStore.class, hint);
                }
                catch (ComponentLookupException e) {
                    throw new InitializationException(String.format("Failed to get the configured event store [%s]", hint), (Throwable)e);
                }
            } else {
                if (this.configuration.isEventStoreSet()) {
                    throw new InitializationException(String.format("Could not find the configured implementation of event store with hint [%s]", hint));
                }
                this.logger.warn("No default implementation of EventStore could be found. No event will be stored (except in the legacy store if available).");
            }
        }
        String string = legacyHint = this.store != null ? "legacy" : "legacy/verbose";
        if (this.componentManager.hasComponent(EventStore.class, legacyHint)) {
            try {
                this.legacyStore = (EventStore)this.componentManager.getInstance(EventStore.class, legacyHint);
            }
            catch (ComponentLookupException e) {
                throw new InitializationException(String.format("Failed to get the legacy event stream [%s]", legacyHint), (Throwable)e);
            }
        }
    }

    @Override
    public CompletableFuture<Event> saveEvent(Event event) {
        this.prepareEvent(event);
        CompletableFuture<Event> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.saveEvent(event);
        }
        if (this.store != null) {
            future = this.store.saveEvent(event);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public CompletableFuture<Event> prefilterEvent(Event event) {
        this.prepareEvent(event);
        CompletableFuture<Event> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.prefilterEvent(event);
        }
        if (this.store != null) {
            future = this.store.prefilterEvent(event);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public CompletableFuture<Optional<Event>> deleteEvent(String eventId) {
        CompletableFuture<Optional<Event>> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.deleteEvent(eventId);
        }
        if (this.store != null) {
            future = this.store.deleteEvent(eventId);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public CompletableFuture<Optional<Event>> deleteEvent(Event event) {
        CompletableFuture<Optional<Event>> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.deleteEvent(event);
        }
        if (this.store != null) {
            future = this.store.deleteEvent(event);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public CompletableFuture<EventStatus> saveEventStatus(EventStatus status) {
        CompletableFuture<EventStatus> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.saveEventStatus(status);
        }
        if (this.store != null) {
            future = this.store.saveEventStatus(status);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public CompletableFuture<EventStatus> saveMailEntityEvent(EntityEvent event) {
        CompletableFuture<EventStatus> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.saveMailEntityEvent(event);
        }
        if (this.store != null) {
            future = this.store.saveMailEntityEvent(event);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public CompletableFuture<Optional<EventStatus>> deleteEventStatus(EventStatus status) {
        CompletableFuture<Optional<EventStatus>> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.deleteEventStatus(status);
        }
        if (this.store != null) {
            future = this.store.deleteEventStatus(status);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteEventStatuses(String entityId, Date date) {
        CompletableFuture<Void> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.deleteEventStatuses(entityId, date);
        }
        if (this.store != null) {
            future = this.store.deleteEventStatuses(entityId, date);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public CompletableFuture<Optional<EventStatus>> deleteMailEntityEvent(EntityEvent event) {
        CompletableFuture<Optional<EventStatus>> future = null;
        if (this.legacyStore != null) {
            future = this.legacyStore.deleteMailEntityEvent(event);
        }
        if (this.store != null) {
            future = this.store.deleteMailEntityEvent(event);
        }
        if (future == null) {
            future = new CompletableFuture();
            future.completeExceptionally(new EventStreamException(NO_STORE));
        }
        return future;
    }

    @Override
    public Optional<Event> getEvent(String eventId) throws EventStreamException {
        Optional<Event> event = Optional.empty();
        if (this.store != null) {
            event = this.store.getEvent(eventId);
        } else if (this.legacyStore != null) {
            event = this.legacyStore.getEvent(eventId);
        }
        return event;
    }

    @Override
    public EventSearchResult search(EventQuery query) throws EventStreamException {
        if (this.store != null) {
            return this.store.search(query);
        }
        if (this.legacyStore != null) {
            return this.legacyStore.search(query);
        }
        return EventSearchResult.EMPTY;
    }

    @Override
    public EventSearchResult search(EventQuery query, Set<String> fields) throws EventStreamException {
        if (this.store != null) {
            return this.store.search(query, fields);
        }
        if (this.legacyStore != null) {
            return this.legacyStore.search(query, fields);
        }
        return EventSearchResult.EMPTY;
    }

    private String generateEventId(Event event, ExecutionContext context) {
        String key = String.format("%s-%s-%s-%s", event.getStream(), event.getApplication(), this.serializer.serialize((EntityReference)event.getDocument(), new Object[0]), event.getType());
        long hash = key.hashCode();
        if (hash < 0L) {
            hash = -hash;
        }
        String id = String.format("%d-%d-%s", hash, event.getDate().getTime(), RandomStringUtils.secure().nextAlphanumeric(8));
        if (context != null && context.getProperty(GROUP_ID_CONTEXT_KEY) == null) {
            context.setProperty(GROUP_ID_CONTEXT_KEY, (Object)id);
        }
        return id;
    }

    private void prepareEvent(Event event) {
        String wikiId;
        ExecutionContext context = this.execution.getContext();
        if (event.getUser() == null) {
            event.setUser(this.documentAccessBridge.getCurrentUserReference());
        }
        if (event.getWiki() == null && (wikiId = this.wikiDescriptorManager.getCurrentWikiId()) != null) {
            event.setWiki(new WikiReference(wikiId));
        }
        if (event.getApplication() == null) {
            event.setApplication("xwiki");
        }
        if (event.getDate() == null) {
            event.setDate(new Date());
        }
        if (event.getId() == null) {
            event.setId(this.generateEventId(event, context));
        }
        if (event.getGroupId() == null && context != null) {
            event.setGroupId((String)context.getProperty(GROUP_ID_CONTEXT_KEY));
        }
    }

    @Override
    public List<EventStatus> getEventStatuses(Collection<Event> events, Collection<String> entityIds) throws Exception {
        if (this.store != null) {
            return this.store.getEventStatuses(events, entityIds);
        }
        if (this.legacyStore != null) {
            return this.legacyStore.getEventStatuses(events, entityIds);
        }
        return List.of();
    }
}

