/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

public class DefaultEvent
implements Event {
    private static final MessageFormat STRING_FORMAT = new MessageFormat("{0} at {1,time,yyyy-MM-dd HH:mm:ss} by {2} on {3} with id {4}");
    private String id;
    private String groupId;
    private String type;
    private Date date;
    private Event.Importance importance = Event.Importance.MEDIUM;
    private String application;
    private String stream;
    private WikiReference wiki;
    private SpaceReference space;
    private DocumentReference document;
    private EntityReference relatedEntity;
    private String documentVersion;
    private String documentTitle;
    private DocumentReference user;
    private URL url;
    private String title;
    private String body;
    private Map<String, String> parametersCache;
    private Map<String, Object> custom;
    private Set<String> target;
    private boolean hidden;
    private boolean prefiltered;
    private String observationInstanceId;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String id) {
        this.groupId = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public Event.Importance getImportance() {
        return this.importance;
    }

    @Override
    public void setImportance(Event.Importance importance) {
        this.importance = importance == null ? Event.Importance.MEDIUM : importance;
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public void setApplication(String application) {
        this.application = application;
    }

    @Override
    public String getStream() {
        return this.stream;
    }

    @Override
    public void setStream(String stream) {
        this.stream = stream;
    }

    @Override
    public WikiReference getWiki() {
        WikiReference result = null;
        if (this.wiki != null) {
            result = this.wiki;
        } else if (this.space != null) {
            result = (WikiReference)this.space.getRoot();
        } else if (this.document != null) {
            result = this.document.getWikiReference();
        }
        return result;
    }

    @Override
    public void setWiki(WikiReference wiki) {
        this.wiki = wiki;
    }

    @Override
    public SpaceReference getSpace() {
        SpaceReference result = null;
        if (this.space != null) {
            result = this.space;
        } else if (this.document != null) {
            result = this.document.getLastSpaceReference();
        }
        return result;
    }

    @Override
    public void setSpace(SpaceReference space) {
        this.space = space;
    }

    @Override
    public DocumentReference getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(DocumentReference document) {
        this.document = document;
    }

    @Override
    public String getDocumentVersion() {
        return this.documentVersion;
    }

    @Override
    public void setDocumentVersion(String version) {
        this.documentVersion = version;
    }

    @Override
    public EntityReference getRelatedEntity() {
        return this.relatedEntity;
    }

    @Override
    public void setRelatedEntity(EntityReference entity) {
        this.relatedEntity = entity;
    }

    @Override
    public DocumentReference getUser() {
        return this.user;
    }

    @Override
    public void setUser(DocumentReference user) {
        this.user = user;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String getDocumentTitle() {
        return this.documentTitle;
    }

    @Override
    public void setDocumentTitle(String title) {
        this.documentTitle = title;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.parametersCache == null) {
            Map parameters;
            if (MapUtils.isEmpty(this.custom)) {
                parameters = Collections.emptyMap();
            } else {
                parameters = new HashMap(this.custom.size());
                this.custom.forEach((k, v) -> parameters.put(k, v != null ? v.toString() : null));
            }
            this.parametersCache = parameters;
        }
        return this.parametersCache;
    }

    @Override
    public Map<String, Object> getCustom() {
        if (this.custom == null) {
            this.custom = Collections.emptyMap();
        }
        return this.custom;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.setCustom(parameters);
    }

    @Override
    public void setCustom(Map<String, ?> custom) {
        this.custom = custom != null ? Collections.unmodifiableMap(new HashMap(custom)) : Collections.emptyMap();
        this.parametersCache = null;
    }

    @Override
    public void setTarget(Set<String> target) {
        this.target = target;
    }

    @Override
    public Set<String> getTarget() {
        return this.target != null ? Collections.unmodifiableSet(this.target) : Collections.emptySet();
    }

    public String toString() {
        return STRING_FORMAT.format(new Object[]{this.getType(), this.getDate(), this.getUser(), this.getDocument(), this.getId()});
    }

    @Override
    public boolean getHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean isHidden) {
        this.hidden = isHidden;
    }

    @Override
    public boolean isPrefiltered() {
        return this.prefiltered;
    }

    @Override
    public void setPrefiltered(boolean prefiltered) {
        this.prefiltered = prefiltered;
    }

    @Override
    public String getRemoteObservationId() {
        return this.observationInstanceId;
    }

    public void setRemoteObservationId(String observationInstanceId) {
        this.observationInstanceId = observationInstanceId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Event) {
            Event otherEvent = (Event)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getApplication(), (Object)otherEvent.getApplication());
            builder.append((Object)this.getBody(), (Object)otherEvent.getBody());
            builder.append((Object)this.getDate(), (Object)otherEvent.getDate());
            builder.append((Object)this.getDocument(), (Object)otherEvent.getDocument());
            builder.append((Object)this.getDocumentTitle(), (Object)otherEvent.getDocumentTitle());
            builder.append((Object)this.getDocumentVersion(), (Object)otherEvent.getDocumentVersion());
            builder.append((Object)this.getGroupId(), (Object)otherEvent.getGroupId());
            builder.append(this.getHidden(), otherEvent.getHidden());
            builder.append((Object)this.getId(), (Object)otherEvent.getId());
            builder.append((Object)this.getImportance(), (Object)otherEvent.getImportance());
            builder.append(this.getCustom(), otherEvent.getCustom());
            builder.append((Object)this.getRelatedEntity(), (Object)otherEvent.getRelatedEntity());
            builder.append((Object)this.getSpace(), (Object)otherEvent.getSpace());
            builder.append((Object)this.getStream(), (Object)otherEvent.getStream());
            builder.append(this.getTarget(), otherEvent.getTarget());
            builder.append((Object)this.getTitle(), (Object)otherEvent.getTitle());
            builder.append((Object)this.getType(), (Object)otherEvent.getType());
            builder.append((Object)this.getUrl(), (Object)otherEvent.getUrl());
            builder.append((Object)this.getUser(), (Object)otherEvent.getUser());
            builder.append((Object)this.getWiki(), (Object)otherEvent.getWiki());
            builder.append(this.isPrefiltered(), otherEvent.isPrefiltered());
            return builder.build();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getApplication());
        builder.append((Object)this.getBody());
        builder.append((Object)this.getDate());
        builder.append((Object)this.getDocument());
        builder.append((Object)this.getDocumentTitle());
        builder.append((Object)this.getDocumentVersion());
        builder.append((Object)this.getGroupId());
        builder.append(this.getHidden());
        builder.append((Object)this.getId());
        builder.append((Object)this.getImportance());
        builder.append(this.getCustom());
        builder.append((Object)this.getRelatedEntity());
        builder.append((Object)this.getSpace());
        builder.append((Object)this.getStream());
        builder.append(this.getTarget());
        builder.append((Object)this.getTitle());
        builder.append((Object)this.getType());
        builder.append((Object)this.getUrl());
        builder.append((Object)this.getUser());
        builder.append((Object)this.getWiki());
        builder.append(this.isPrefiltered());
        return builder.build();
    }
}

