/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.concurrent.ContextStoreManager;
import org.xwiki.eventstream.EntityEvent;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.events.EventStreamAddedEvent;
import org.xwiki.eventstream.events.EventStreamDeletedEvent;
import org.xwiki.eventstream.events.MailEntityAddedEvent;
import org.xwiki.eventstream.events.MailEntityDeleteEvent;
import org.xwiki.eventstream.internal.events.EventStatusAddOrUpdatedEvent;
import org.xwiki.eventstream.internal.events.EventStatusDeletedEvent;
import org.xwiki.observation.ObservationManager;

public abstract class AbstractAsynchronousEventStore
implements EventStore,
Initializable,
Disposable {
    private static final List<String> CONTEXT_ENTRIES = Arrays.asList("user", "author", "wiki");
    @Inject
    protected Logger logger;
    @Inject
    protected ComponentDescriptor<EventStore> descriptor;
    @Inject
    protected ObservationManager observation;
    @Inject
    private ContextStoreManager contextStore;
    @Inject
    private Execution execution;
    private Thread thread;
    private int queueCapacity;
    private BlockingQueue<EventStoreTask<?, ?>> queue;
    private boolean notifyEach;
    private boolean notifyAll;
    private boolean disposed;

    public int getQueueSize() {
        int size = 0;
        for (EventStoreTask eventStoreTask : this.queue) {
            switch (eventStoreTask.type) {
                case DELETE_EVENT: 
                case DELETE_EVENT_BY_ID: {
                    --size;
                    break;
                }
                case SAVE_EVENT: {
                    ++size;
                    break;
                }
            }
        }
        return size;
    }

    private <O, I> CompletableFuture<O> addTask(I input, EventStoreTaskType type) {
        Map context;
        try {
            context = this.contextStore.save(CONTEXT_ENTRIES);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to save context of the event", (Throwable)e);
            context = null;
        }
        EventStoreTask task = new EventStoreTask(input, type, context);
        this.addTask(task);
        return task.future;
    }

    private <O, I> void addTask(EventStoreTask<O, I> task) {
        try {
            this.queue.put(task);
        }
        catch (InterruptedException e) {
            task.future.completeExceptionally(e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CompletableFuture<Event> saveEvent(Event event) {
        return this.addTask(event, EventStoreTaskType.SAVE_EVENT);
    }

    @Override
    public CompletableFuture<EventStatus> saveEventStatus(EventStatus status) {
        return this.addTask(status, EventStoreTaskType.SAVE_STATUS);
    }

    @Override
    public CompletableFuture<EventStatus> saveMailEntityEvent(EntityEvent event) {
        return this.addTask(event, EventStoreTaskType.SAVE_MAIL_ENTITY);
    }

    @Override
    public CompletableFuture<Optional<Event>> deleteEvent(String eventId) {
        return this.addTask(eventId, EventStoreTaskType.DELETE_EVENT_BY_ID);
    }

    @Override
    public CompletableFuture<Optional<Event>> deleteEvent(Event event) {
        return this.addTask(event, EventStoreTaskType.DELETE_EVENT);
    }

    @Override
    public CompletableFuture<Optional<EventStatus>> deleteEventStatus(EventStatus status) {
        return this.addTask(status, EventStoreTaskType.DELETE_STATUS);
    }

    @Override
    public CompletableFuture<Void> deleteEventStatuses(String entityId, Date date) {
        return this.addTask(new DeleteStatusesData(entityId, date), EventStoreTaskType.DELETE_STATUSES);
    }

    @Override
    public CompletableFuture<Optional<EventStatus>> deleteMailEntityEvent(EntityEvent event) {
        return this.addTask(event, EventStoreTaskType.DELETE_MAIL_ENTITY);
    }

    @Override
    public CompletableFuture<Event> prefilterEvent(Event event) {
        return this.addTask(event, EventStoreTaskType.PREFILTER_EVENT);
    }

    private void run() {
        while (!this.disposed) {
            EventStoreTask<?, ?> firstTask;
            try {
                firstTask = this.queue.take();
            }
            catch (InterruptedException e) {
                this.logger.warn("The thread handling asynchronous storage for event store [{}] has been interrupted", (Object)this.descriptor.getRoleHint(), (Object)e);
                Thread.currentThread().interrupt();
                break;
            }
            this.processTasks(firstTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTasks(EventStoreTask<?, ?> firstTask) {
        this.execution.setContext(new ExecutionContext());
        ArrayList tasks = new ArrayList(this.queueCapacity);
        try {
            EventStoreTask task = firstTask;
            while (task != null) {
                block8: {
                    if (task == EventStoreTask.STOP) {
                        break;
                    }
                    try {
                        this.processTask(task);
                        tasks.add(task);
                        if (tasks.size() != this.queueCapacity) break block8;
                        break;
                    }
                    catch (Exception e) {
                        task.future.completeExceptionally(e);
                    }
                }
                task = (EventStoreTask)this.queue.poll();
            }
        }
        finally {
            this.afterTasks(tasks);
            this.execution.removeContext();
        }
    }

    private boolean processTask(EventStoreTask<?, ?> task) throws EventStreamException {
        switch (task.type) {
            case DELETE_EVENT: {
                this.processTaskOutput(task, this.syncDeleteEvent((Event)task.input));
                break;
            }
            case DELETE_EVENT_BY_ID: {
                this.processTaskOutput(task, this.syncDeleteEvent((String)task.input));
                break;
            }
            case SAVE_EVENT: {
                this.processTaskOutput(task, this.syncSaveEvent((Event)task.input));
                break;
            }
            case DELETE_STATUS: {
                this.processTaskOutput(task, this.syncDeleteEventStatus((EventStatus)task.input));
                break;
            }
            case DELETE_STATUSES: {
                EventStoreTask<?, ?> deleteStatusesTask = task;
                this.processTaskOutput(deleteStatusesTask, this.syncDeleteEventStatuses(((DeleteStatusesData)deleteStatusesTask.input).entityId, ((DeleteStatusesData)deleteStatusesTask.input).date));
                break;
            }
            case SAVE_STATUS: {
                this.processTaskOutput(task, this.syncSaveEventStatus((EventStatus)task.input));
                break;
            }
            case DELETE_MAIL_ENTITY: {
                this.processTaskOutput(task, this.syncDeleteMailEntityEvent((EntityEvent)task.input));
                break;
            }
            case SAVE_MAIL_ENTITY: {
                this.processTaskOutput(task, this.syncSaveMailEntityEvent((EntityEvent)task.input));
                break;
            }
            case PREFILTER_EVENT: {
                this.processTaskOutput(task, this.syncPrefilterEvent((Event)task.input));
                break;
            }
        }
        return false;
    }

    private <O, I> void processTaskOutput(EventStoreTask<O, I> task, O output) {
        task.output = output;
        if (this.notifyEach) {
            this.complete(task, output);
        }
    }

    private <O, I> void complete(EventStoreTask<O, I> task, O output) {
        if (task.context != null) {
            try {
                this.contextStore.restore(task.context);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to restore context of the event", output, (Object)e);
            }
        }
        task.future.complete(output);
        Object notificationOuput = task.output;
        boolean skipNotify = false;
        if (task.output instanceof Optional) {
            Optional optionalOutput = (Optional)task.output;
            if (optionalOutput.isPresent()) {
                notificationOuput = optionalOutput.get();
            } else {
                skipNotify = true;
            }
        }
        if (!skipNotify) {
            switch (task.type) {
                case DELETE_EVENT: {
                    this.observation.notify((org.xwiki.observation.event.Event)new EventStreamDeletedEvent(), notificationOuput);
                    break;
                }
                case DELETE_EVENT_BY_ID: {
                    this.observation.notify((org.xwiki.observation.event.Event)new EventStreamDeletedEvent(), notificationOuput);
                    break;
                }
                case SAVE_EVENT: {
                    this.observation.notify((org.xwiki.observation.event.Event)new EventStreamAddedEvent(), notificationOuput);
                    break;
                }
                case DELETE_STATUS: {
                    this.observation.notify((org.xwiki.observation.event.Event)new EventStatusDeletedEvent(), notificationOuput);
                    break;
                }
                case DELETE_STATUSES: {
                    this.observation.notify((org.xwiki.observation.event.Event)new EventStatusDeletedEvent(), null);
                    break;
                }
                case SAVE_STATUS: {
                    this.observation.notify((org.xwiki.observation.event.Event)new EventStatusAddOrUpdatedEvent(), notificationOuput);
                    break;
                }
                case DELETE_MAIL_ENTITY: {
                    this.observation.notify((org.xwiki.observation.event.Event)new MailEntityDeleteEvent(), notificationOuput);
                    break;
                }
                case SAVE_MAIL_ENTITY: {
                    this.observation.notify((org.xwiki.observation.event.Event)new MailEntityAddedEvent(), notificationOuput);
                    break;
                }
            }
        }
    }

    protected abstract EventStatus syncSaveEventStatus(EventStatus var1) throws EventStreamException;

    protected abstract EntityEvent syncSaveMailEntityEvent(EntityEvent var1) throws EventStreamException;

    protected abstract Event syncSaveEvent(Event var1) throws EventStreamException;

    protected abstract Event syncPrefilterEvent(Event var1) throws EventStreamException;

    protected abstract Optional<EventStatus> syncDeleteEventStatus(EventStatus var1) throws EventStreamException;

    protected abstract Void syncDeleteEventStatuses(String var1, Date var2) throws EventStreamException;

    protected abstract Optional<EntityEvent> syncDeleteMailEntityEvent(EntityEvent var1) throws EventStreamException;

    protected abstract Optional<Event> syncDeleteEvent(String var1) throws EventStreamException;

    protected abstract Optional<Event> syncDeleteEvent(Event var1) throws EventStreamException;

    protected void afterTasks(List<EventStoreTask<?, ?>> tasks) {
        if (this.notifyAll) {
            for (EventStoreTask<?, ?> task : tasks) {
                this.complete(task, task.output);
            }
        }
    }

    protected void initialize(int queueCapacity, boolean notifyEach, boolean notifyAll) {
        this.notifyEach = notifyEach;
        this.notifyAll = !notifyEach && notifyAll;
        this.queueCapacity = queueCapacity;
        this.queue = new LinkedBlockingQueue(this.queueCapacity);
        this.thread = new Thread(this::run);
        this.thread.setName("Asynchronous handler for event store [" + this.descriptor.getRoleHint() + "]");
        this.thread.setPriority(4);
        this.thread.start();
    }

    public void dispose() throws ComponentLifecycleException {
        this.disposed = true;
        this.addTask(EventStoreTask.STOP);
        try {
            this.thread.join(10000L);
        }
        catch (InterruptedException e) {
            this.logger.warn("The thread handling asynchronous storage for event store [{}] has been interrupted", (Object)this.descriptor.getRoleHint(), (Object)e);
            this.thread.interrupt();
        }
    }

    protected static class EventStoreTask<O, I> {
        public static final EventStoreTask<Object, Object> STOP = new EventStoreTask(null, null, null);
        private final CompletableFuture<O> future;
        private final I input;
        private final EventStoreTaskType type;
        private final Map<String, Serializable> context;
        private O output;

        protected EventStoreTask(I input, EventStoreTaskType type, Map<String, Serializable> contextStore) {
            this.input = input;
            this.type = type;
            this.context = contextStore;
            this.future = new CompletableFuture();
        }

        public I getInput() {
            return this.input;
        }

        public EventStoreTaskType getType() {
            return this.type;
        }
    }

    protected static enum EventStoreTaskType {
        SAVE_EVENT,
        SAVE_STATUS,
        SAVE_MAIL_ENTITY,
        DELETE_EVENT,
        DELETE_EVENT_BY_ID,
        DELETE_STATUS,
        DELETE_STATUSES,
        DELETE_MAIL_ENTITY,
        PREFILTER_EVENT;

    }

    private static class DeleteStatusesData {
        private final String entityId;
        private final Date date;

        DeleteStatusesData(String entityId, Date date) {
            this.entityId = entityId;
            this.date = date;
        }
    }
}

