/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.edit.internal.AbstractEditorBindingsSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;

@Component
@Named(value="editorBindings/space")
@Singleton
public class SpaceEditorBindingsSource
extends AbstractEditorBindingsSource {
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    protected String getCacheId() {
        return "configuration.editorBindings.space";
    }

    protected String getCacheKeyPrefix() {
        DocumentReference currentDocumentReference = this.documentAccessBridge.getCurrentDocumentReference();
        if (currentDocumentReference != null) {
            return (String)this.referenceSerializer.serialize(currentDocumentReference.getParent(), new Object[0]);
        }
        return null;
    }

    protected DocumentReference getDocumentReference() {
        DocumentReference currentDocumentReference = this.documentAccessBridge.getCurrentDocumentReference();
        if (currentDocumentReference != null) {
            return new DocumentReference("WebPreferences", (SpaceReference)currentDocumentReference.getParent());
        }
        return null;
    }
}

