/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.lang.reflect.Type;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.edit.AbstractEditor;
import org.xwiki.edit.EditException;
import org.xwiki.edit.Editor;
import org.xwiki.edit.EditorDescriptor;
import org.xwiki.edit.EditorDescriptorBuilder;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component(roles={EditorWikiComponent.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class EditorWikiComponent<D>
extends AbstractEditor<D>
implements WikiComponent {
    private static final LocalDocumentReference EDITOR_CLASS_REFERENCE = new LocalDocumentReference("XWiki", "EditorClass");
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private UserReference authorReference;
    private DocumentReference editorReference;
    private Type roleType;
    private WikiComponentScope scope;
    @Inject
    private EditorDescriptorBuilder descriptorBuilder;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userReferenceDocumentReferenceSerializer;

    public DocumentReference getAuthorReference() {
        if (this.authorReference != null && this.authorReference != GuestUserReference.INSTANCE) {
            return (DocumentReference)this.userReferenceDocumentReferenceSerializer.serialize(this.authorReference);
        }
        return null;
    }

    public DocumentReference getDocumentReference() {
        return this.editorReference;
    }

    public String getRoleHint() {
        return this.descriptorBuilder.getId();
    }

    public Type getRoleType() {
        return this.roleType;
    }

    public WikiComponentScope getScope() {
        return this.scope;
    }

    public EditorDescriptor getDescriptor() {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument editorDocument = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
            XWikiDocument translatedEditorDocument = editorDocument.getTranslatedDocument(xcontext);
            this.descriptorBuilder.setName(translatedEditorDocument.getRenderedTitle(Syntax.PLAIN_1_0, xcontext));
            this.descriptorBuilder.setDescription(translatedEditorDocument.getRenderedContent(Syntax.PLAIN_1_0, xcontext));
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to read the editor name and description. Root cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return this.descriptorBuilder.build();
    }

    protected String render() throws EditException {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument editorDocument = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
            BaseObject editorObject = editorDocument.getXObject((EntityReference)EDITOR_CLASS_REFERENCE);
            String editorCode = editorObject.getStringValue("code");
            XWikiDocument sdoc = editorDocument;
            return xcontext.getDoc().getRenderedContent(editorCode, editorDocument.getSyntax().toIdString(), false, sdoc, xcontext);
        }
        catch (Exception e) {
            throw new EditException("Failed to render the editor code.", (Throwable)e);
        }
    }

    public void initialize(DocumentReference editorReference) throws WikiComponentException {
        if (this.editorReference != null) {
            throw new WikiComponentException("This editor component is already initialized.");
        }
        this.editorReference = editorReference;
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            this.initialize(xcontext.getWiki().getDocument(editorReference, xcontext));
        }
        catch (XWikiException e) {
            throw new WikiComponentException("Failed to load the editor document.", (Throwable)e);
        }
    }

    private void initialize(XWikiDocument editorDocument) throws WikiComponentException {
        this.authorReference = editorDocument.getAuthors().getEffectiveMetadataAuthor();
        BaseObject editorObject = editorDocument.getXObject((EntityReference)EDITOR_CLASS_REFERENCE);
        if (editorObject == null) {
            throw new WikiComponentException(String.format("The document [%s] is missing the XWiki.EditorClass object.", editorDocument.getDocumentReference()));
        }
        this.initialize(editorObject);
    }

    private void initialize(BaseObject editorObject) throws WikiComponentException {
        this.descriptorBuilder.setId(editorObject.getStringValue("roleHint"));
        this.descriptorBuilder.setIcon(editorObject.getStringValue("icon"));
        this.descriptorBuilder.setCategory(editorObject.getStringValue("category"));
        this.scope = WikiComponentScope.fromString((String)editorObject.getStringValue("scope"));
        String dataTypeName = editorObject.getStringValue("dataType");
        try {
            Type dataType = ReflectionUtils.unserializeType((String)dataTypeName, (ClassLoader)Thread.currentThread().getContextClassLoader());
            this.roleType = new DefaultParameterizedType(null, Editor.class, new Type[]{dataType});
        }
        catch (ClassNotFoundException e) {
            throw new WikiComponentException(String.format("The [%s] data type does not exist.", dataTypeName), (Throwable)e);
        }
    }
}

