/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.edit.EditorConfiguration;
import org.xwiki.rendering.block.XDOM;

@Component
@Singleton
public class XDOMEditorConfiguration
implements EditorConfiguration<XDOM> {
    @Inject
    @Named(value="user")
    private ConfigurationSource userConfig;
    @Inject
    @Named(value="documents")
    private ConfigurationSource documentsConfig;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikiConfig;

    @Override
    public String getDefaultEditor() {
        String propertyName = "editor";
        String defaultEditor = (String)this.userConfig.getProperty(propertyName, String.class);
        if (StringUtils.isEmpty((CharSequence)defaultEditor) && StringUtils.isEmpty((CharSequence)(defaultEditor = (String)this.documentsConfig.getProperty(propertyName, String.class)))) {
            defaultEditor = (String)this.xwikiConfig.getProperty("xwiki.editor", (Object)"text");
        }
        return StringUtils.lowerCase((String)defaultEditor);
    }

    @Override
    public String getDefaultEditor(String category) {
        if (StringUtils.isEmpty((CharSequence)category)) {
            return this.getDefaultEditor();
        }
        if ("text".equals(category)) {
            return "text";
        }
        return null;
    }
}

