/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.internal;

import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.edit.EditorDescriptor;
import org.xwiki.edit.EditorDescriptorBuilder;
import org.xwiki.edit.internal.DefaultEditorDescriptor;
import org.xwiki.localization.ContextualLocalizationManager;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultEditorDescriptorBuilder
implements EditorDescriptorBuilder {
    private String id;
    private String name;
    private String description;
    private String icon;
    private String category;
    @Inject
    private ContextualLocalizationManager localization;

    @Override
    public DefaultEditorDescriptorBuilder setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public DefaultEditorDescriptorBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DefaultEditorDescriptorBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DefaultEditorDescriptorBuilder setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public DefaultEditorDescriptorBuilder setCategory(String category) {
        this.category = category;
        return this;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public EditorDescriptor build() {
        if (StringUtils.isEmpty((CharSequence)this.id)) {
            throw new RuntimeException("The editor id is mandatory.");
        }
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            this.name = this.localization.getTranslationPlain(String.format("edit.editor.%s.name", this.id), new Object[0]);
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                this.name = this.id;
            }
        }
        if (this.description == null) {
            this.description = this.localization.getTranslationPlain(String.format("edit.editor.%s.description", this.id), new Object[0]);
        }
        return new DefaultEditorDescriptor(this.id, this.name, this.description, this.icon, this.category);
    }
}

