/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.migrations.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiPreferencesDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.IndexException;
import org.xwiki.index.TaskConsumer;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="xwiki-properties-meta-field-cleanup")
@Singleton
public class XWikiPropertiesMetaFieldCleanupTaskConsumer
implements TaskConsumer {
    static final String TASK_NAME = "xwiki-properties-meta-field-cleanup";
    private static final String META_FIELD = "meta";
    @Inject
    private Provider<XWikiContext> contextProvider;

    public void consume(DocumentReference documentReference, String version) throws IndexException {
        BaseObject xObject;
        XWikiDocument document;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki wiki = context.getWiki();
        try {
            document = wiki.getDocument(documentReference, context).clone();
        }
        catch (XWikiException e) {
            throw new IndexException("Unable to retrieve document [%s]".formatted(documentReference), (Throwable)e);
        }
        if (document != null && (xObject = document.getXObject((EntityReference)XWikiPreferencesDocumentInitializer.LOCAL_REFERENCE)) != null && StringUtils.isNotEmpty((CharSequence)xObject.getStringValue(META_FIELD))) {
            xObject.setStringValue(META_FIELD, "");
            try {
                wiki.saveDocument(document, "[UPGRADE] empty field [%s] because it matches the default values".formatted(META_FIELD), context);
            }
            catch (XWikiException e) {
                throw new IndexException("Unable to save document [%s]".formatted(documentReference), (Throwable)e);
            }
        }
    }
}

