/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.migrations.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiPreferencesDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.index.TaskManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;

@Component
@Named(value="R170400000XWIKI23160")
@Singleton
public class R170400000XWIKI23160DataMigration
extends AbstractHibernateDataMigration {
    private static final String META_FIELD = "meta";
    private static final Set<String> DISTRIBUTION_XAR_IDS = Set.of("org.xwiki.platform:xwiki-platform-distribution-ui-base", "org.xwiki.platform:xwiki-platform-distribution-flavor");
    @Inject
    private Packager packager;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private TaskManager taskManager;

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(170400000);
    }

    public String getDescription() {
        return "Cleanup XWikiProperties fields used as templates when they match the default values.";
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        XWikiContext xWikiContext = this.getXWikiContext();
        XWiki wiki = xWikiContext.getWiki();
        DocumentReference xwikiPreferencesDocumentReference = new DocumentReference(new LocalDocumentReference((EntityReference)XWikiPreferencesDocumentInitializer.LOCAL_REFERENCE, Locale.ROOT), xWikiContext.getWikiReference());
        XWikiDocument xwikiPreferencesDocument = wiki.getDocument(xwikiPreferencesDocumentReference, xWikiContext);
        XWikiDocument xwikiPreferencesDocumentFromXar = this.loadFromXar(xwikiPreferencesDocumentReference);
        if (xwikiPreferencesDocumentFromXar != null) {
            this.runMigration(xWikiContext, xwikiPreferencesDocument, xwikiPreferencesDocumentFromXar);
        }
    }

    private void runMigration(XWikiContext xWikiContext, XWikiDocument xwikiPreferencesDocument, XWikiDocument xwikiPreferencesDocumentFromXar) {
        String templateFromXar;
        String template;
        WikiReference wikiReference = xWikiContext.getWikiReference();
        BaseObject xwikiPreferencesXObject = xwikiPreferencesDocument.getXObject((EntityReference)XWikiPreferencesDocumentInitializer.LOCAL_REFERENCE);
        BaseObject xwikiPreferencesXObjectFromXar = xwikiPreferencesDocumentFromXar.getXObject((EntityReference)XWikiPreferencesDocumentInitializer.LOCAL_REFERENCE);
        if (xwikiPreferencesXObject != null && xwikiPreferencesXObjectFromXar != null && StringUtils.isNotEmpty((CharSequence)(template = xwikiPreferencesXObject.getStringValue(META_FIELD))) && template.equals(templateFromXar = xwikiPreferencesXObjectFromXar.getStringValue(META_FIELD))) {
            this.taskManager.addTask(wikiReference.getName(), xwikiPreferencesDocument.getId(), "xwiki-properties-meta-field-cleanup");
        }
    }

    private XWikiDocument loadFromXar(DocumentReference xwikiPreferencesDocumentReference) throws DataMigrationException {
        InstalledExtensionRepository installedExtensionRepository = this.installedExtensionRepository;
        if (installedExtensionRepository instanceof XarInstalledExtensionRepository) {
            XarInstalledExtensionRepository xarInstalledExtensionRepository = (XarInstalledExtensionRepository)installedExtensionRepository;
            Collection xarInstalledExtensions = xarInstalledExtensionRepository.getXarInstalledExtensions(xwikiPreferencesDocumentReference);
            XarInstalledExtension xarInstalledExtension = xarInstalledExtensions.stream().filter(it -> DISTRIBUTION_XAR_IDS.contains(it.getId().getId())).findFirst().orElse(null);
            if (xarInstalledExtension != null) {
                ExtensionId extensionId = xarInstalledExtension.getId();
                try {
                    XarEntry localDocumentReference = new XarEntry(xwikiPreferencesDocumentReference.getLocalDocumentReference(), "XWiki/XWikiPreferences.xml");
                    return this.packager.getXWikiDocument(xwikiPreferencesDocumentReference.getWikiReference(), (LocalDocumentReference)localDocumentReference, xarInstalledExtension);
                }
                catch (IOException | XarException e) {
                    throw new DataMigrationException("Failed to load [%s] from extension [%s]".formatted(xwikiPreferencesDocumentReference, extensionId), e);
                }
            }
            return null;
        }
        throw new DataMigrationException("The resolved [%s] component cannot be cast to [%s]".formatted(InstalledExtensionRepository.class, XarInstalledExtensionRepository.class));
    }
}

