/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.display;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.macro.include.AbstractIncludeMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.display.DisplayMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="display")
@Singleton
public class DisplayMacro
extends AbstractIncludeMacro<DisplayMacroParameters> {
    private static final String DISPLAY = "display";
    private static final String DESCRIPTION = "Display other pages into the current page.";

    public DisplayMacro() {
        super("Display", DESCRIPTION, DisplayMacroParameters.class);
        this.setDefaultCategories(Set.of("Content"));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(DisplayMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM result;
        Stack<DocumentReference> references;
        DocumentModelBridge documentBridge;
        EntityReference displayedReference = this.resolve(context.getCurrentMacroBlock(), parameters.getReference(), parameters.getType(), DISPLAY);
        this.checkRecursion(displayedReference, DISPLAY);
        try {
            documentBridge = this.documentAccessBridge.getDocumentInstance(displayedReference);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to load Document [" + (String)this.defaultEntityReferenceSerializer.serialize(displayedReference, new Object[0]) + "]", (Throwable)e);
        }
        if (documentBridge.isNew()) {
            return List.of();
        }
        if (!this.contextualAuthorization.hasAccess(Right.VIEW, (EntityReference)documentBridge.getDocumentReference())) {
            throw new MacroExecutionException(String.format("Current user [%s] doesn't have view rights on document [%s]", this.documentAccessBridge.getCurrentUserReference(), documentBridge.getDocumentReference()));
        }
        DocumentDisplayerParameters displayParameters = new DocumentDisplayerParameters();
        displayParameters.setContentTransformed(true);
        displayParameters.setExecutionContextIsolated(displayParameters.isContentTransformed());
        displayParameters.setSectionId(parameters.getSection());
        displayParameters.setTransformationContextIsolated(displayParameters.isContentTransformed());
        displayParameters.setTargetSyntax(context.getTransformationContext().getTargetSyntax());
        displayParameters.setContentTranslated(true);
        if (context.getXDOM() != null) {
            displayParameters.setIdGenerator(context.getXDOM().getIdGenerator());
        }
        if ((references = (Stack<DocumentReference>)this.macrosBeingExecuted.get()) == null) {
            references = new Stack<DocumentReference>();
            this.macrosBeingExecuted.set(references);
        }
        references.push(documentBridge.getDocumentReference());
        try {
            result = this.documentDisplayer.display((Object)documentBridge, (Object)displayParameters);
        }
        catch (Exception e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
        finally {
            references.pop();
            if (references.isEmpty()) {
                this.macrosBeingExecuted.remove();
            }
        }
        if (parameters.isExcludeFirstHeading()) {
            this.excludeFirstHeading(result);
        }
        this.maybeConvertToInline(result, context);
        MetaDataBlock metadata = new MetaDataBlock(result.getChildren(), result.getMetaData());
        String source = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)documentBridge.getDocumentReference(), new Object[0]);
        metadata.getMetaData().addMetaData("source", (Object)source);
        metadata.getMetaData().addMetaData("base", (Object)source);
        return Collections.singletonList(metadata);
    }
}

