/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentContentAsyncExecutor;
import org.xwiki.display.internal.DocumentContentAsyncParser;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.internal.AsyncProperties;
import org.xwiki.rendering.async.internal.block.AbstractBlockAsyncRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={DocumentContentAsyncRenderer.class})
public class DocumentContentAsyncRenderer
extends AbstractBlockAsyncRenderer {
    @Inject
    private DocumentContentAsyncExecutor executor;
    @Inject
    private AsyncContext asyncContext;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private DocumentContentAsyncParser asyncParser;
    private DocumentDisplayerParameters parameters;
    private AsyncProperties asyncProperties;
    private DocumentReference documentReference;
    private List<String> id;

    public Set<String> initialize(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        this.parameters = parameters;
        if (document.isRestricted()) {
            parameters.setTransformationContextRestricted(true);
        }
        this.asyncProperties = this.asyncParser.getAsyncProperties(document);
        String transformationId = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)(parameters.isContentTransformed() && parameters.isTransformationContextIsolated() ? document.getDocumentReference() : this.documentAccessBridge.getCurrentDocumentReference()), new Object[0]);
        this.documentReference = document.getDocumentReference();
        if (this.asyncProperties.isAsyncAllowed() || this.asyncProperties.isCacheAllowed()) {
            this.id = this.createId(new Object[]{"display", "document", "content", this.defaultEntityReferenceSerializer.serialize((EntityReference)this.documentReference, new Object[0]), this.parameters.getSectionId(), this.parameters.getTargetSyntax() != null ? this.parameters.getTargetSyntax().toIdString() : "", transformationId, this.parameters.isContentTransformed(), this.parameters.isTransformationContextRestricted(), this.parameters.isTransformationContextIsolated()});
        }
        this.executor.initialize(transformationId, document, parameters);
        return this.asyncProperties.getContextElements();
    }

    public Block execute(boolean async, boolean cached) throws RenderingException {
        this.asyncContext.useEntity((EntityReference)this.documentReference);
        return this.executor.execute(async);
    }

    public List<String> getId() {
        return this.id;
    }

    public boolean isAsyncAllowed() {
        return this.asyncProperties.isAsyncAllowed();
    }

    public boolean isCacheAllowed() {
        return this.asyncProperties.isCacheAllowed();
    }

    public boolean isInline() {
        return false;
    }

    public Syntax getTargetSyntax() {
        return this.parameters.getTargetSyntax();
    }
}

