/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.xml.XMLDiffDataURIConverterConfiguration;
import org.xwiki.diff.xml.internal.HttpClientBuilderFactory;
import org.xwiki.security.authentication.AuthenticationConfiguration;

@Component(roles={ImageDownloader.class})
@Singleton
public class ImageDownloader {
    private static final String COOKIE_DOMAIN_PREFIX = ".";
    private static final String HEADER_COOKIE = "Cookie";
    @Inject
    private HttpClientBuilderFactory httpClientBuilderFactory;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private XMLDiffDataURIConverterConfiguration configuration;
    @Inject
    private AuthenticationConfiguration authenticationConfiguration;

    public DownloadResult download(URI uri) throws IOException {
        HttpClientBuilder httpClientBuilder = this.httpClientBuilderFactory.create();
        HttpGet getMethod = this.initializeGetMethod(uri);
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            DownloadResult downloadResult = (DownloadResult)httpClient.execute((ClassicHttpRequest)getMethod, response -> this.handleResponse(uri, response));
            return downloadResult;
        }
    }

    private DownloadResult handleResponse(URI uri, ClassicHttpResponse response) throws IOException {
        if (response.getCode() == 200) {
            byte[] content;
            HttpEntity entity = response.getEntity();
            String contentType = entity.getContentType();
            if (!Strings.CS.startsWith((CharSequence)(contentType = StringUtils.substringBefore((String)contentType, (String)";")), (CharSequence)"image/")) {
                throw new IOException(String.format("The content of [%s] is not an image.", uri));
            }
            long maximumSize = this.configuration.getMaximumContentSize();
            if (maximumSize > 0L && entity.getContentLength() > maximumSize) {
                throw new IOException(String.format("The content length of [%s] is too big.", uri));
            }
            if (maximumSize > 0L) {
                try (BoundedInputStream boundedInputStream = new BoundedInputStream(entity.getContent(), maximumSize);){
                    content = IOUtils.toByteArray((InputStream)boundedInputStream);
                }
                if ((long)content.length == maximumSize) {
                    throw new IOException(String.format("The content of [%s] is too big.", uri));
                }
            } else {
                content = IOUtils.toByteArray((InputStream)entity.getContent());
            }
            return new DownloadResult(content, contentType);
        }
        throw new IOException(response.getCode() + " " + response.getReasonPhrase());
    }

    private HttpGet initializeGetMethod(URI uri) {
        HttpGet getMethod = new HttpGet(uri);
        XWikiRequest request = ((XWikiContext)this.xcontextProvider.get()).getRequest();
        if (request != null && this.matchesCookieDomain(uri.getHost(), (HttpServletRequest)request)) {
            getMethod.setHeader(HEADER_COOKIE, (Object)request.getHeader(HEADER_COOKIE));
        }
        return getMethod;
    }

    private boolean matchesCookieDomain(String host, HttpServletRequest request) {
        String serverName = request.getServerName();
        String prefixedServerName = COOKIE_DOMAIN_PREFIX + serverName;
        Optional<String> cookieDomain = this.authenticationConfiguration.getCookieDomains().stream().filter(prefixedServerName::endsWith).findFirst();
        return cookieDomain.map((COOKIE_DOMAIN_PREFIX + host)::endsWith).orElseGet(() -> host.equals(serverName));
    }

    public static class DownloadResult {
        private final byte[] data;
        private final String contentType;

        public DownloadResult(byte[] data, String contentType) {
            this.data = data;
            this.contentType = contentType;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

