/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.diff.xml.XMLDiffDataURIConverterConfiguration;

@Component
@Singleton
public class DefaultXMLDiffDataURIConverterConfiguration
implements XMLDiffDataURIConverterConfiguration {
    private static final String PREFIX = "diff.xml.dataURI";
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;

    @Override
    public int getHTTPTimeout() {
        return (Integer)this.configurationSource.getProperty(this.getFullKeyName("httpTimeout"), Integer.class, (Object)10);
    }

    @Override
    public long getMaximumContentSize() {
        return (Long)this.configurationSource.getProperty(this.getFullKeyName("maximumContentSize"), Long.class, (Object)0x100000L);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.configurationSource.getProperty(this.getFullKeyName("enabled"), Boolean.class, (Object)true);
    }

    private String getFullKeyName(String shortKeyName) {
        return String.format("%s.%s", PREFIX, shortKeyName);
    }
}

