/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.xml.XMLDiffDataURIConverterConfiguration;
import org.xwiki.diff.xml.internal.DataURIConverter;
import org.xwiki.diff.xml.internal.ImageDownloader;
import org.xwiki.url.URLSecurityManager;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Singleton
public class DefaultDataURIConverter
implements Initializable,
Disposable,
DataURIConverter {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private URLSecurityManager urlSecurityManager;
    @Inject
    private UserReferenceSerializer<String> userReferenceSerializer;
    @Inject
    private ImageDownloader imageDownloader;
    @Inject
    private XMLDiffDataURIConverterConfiguration configuration;
    private Cache<String> cache;
    private Cache<DiffException> failureCache;

    public void initialize() throws InitializationException {
        if (!this.configuration.isEnabled()) {
            return;
        }
        CacheConfiguration cacheConfig = new CacheConfiguration();
        cacheConfig.setConfigurationId("diff.html.dataURI");
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setMaxEntries(100);
        cacheConfig.put((Object)"eviction", (Object)lru);
        CacheConfiguration failureCacheConfiguration = new CacheConfiguration();
        failureCacheConfiguration.setConfigurationId("diff.html.dataURIFailureCache");
        LRUEvictionConfiguration failureLRU = new LRUEvictionConfiguration();
        failureLRU.setMaxEntries(1000);
        failureLRU.setLifespan(3600);
        failureCacheConfiguration.put((Object)"eviction", (Object)failureLRU);
        try {
            this.cache = this.cacheManager.createNewCache(cacheConfig);
            this.failureCache = this.cacheManager.createNewCache(failureCacheConfiguration);
        }
        catch (Exception e) {
            if (this.cache != null) {
                this.cache.dispose();
            }
            throw new InitializationException("Failed to create the Data URI cache.", (Throwable)e);
        }
    }

    public void dispose() {
        if (this.cache != null) {
            this.cache.dispose();
        }
        if (this.failureCache != null) {
            this.failureCache.dispose();
        }
    }

    protected URL getAbsoluteURL(String url, XWikiContext xcontext) throws DiffException {
        URL absoluteURL;
        try {
            if (xcontext.getRequest() != null) {
                URL requestURL = XWiki.getRequestURL((XWikiRequest)xcontext.getRequest());
                absoluteURL = new URL(requestURL, url);
            } else {
                absoluteURL = new URL(url);
            }
        }
        catch (XWikiException | MalformedURLException e) {
            throw new DiffException(String.format("Failed to resolve [%s] to an absolute URL.", url), e);
        }
        return absoluteURL;
    }

    protected static String getDataURI(String contentType, byte[] content) {
        return String.format("data:%s;base64,%s", contentType, Base64.getEncoder().encodeToString(content));
    }

    private String getCacheKey(URL url) {
        String userPart = (String)this.userReferenceSerializer.serialize((UserReference)CurrentUserReference.INSTANCE);
        return String.format("%d:%s:%s", userPart.length(), userPart, url.toString());
    }

    public String convert(String url) throws DiffException {
        if (url.startsWith("data:") || !this.configuration.isEnabled()) {
            return url;
        }
        URL absoluteURL = this.getAbsoluteURL(url, (XWikiContext)this.xcontextProvider.get());
        String cacheKey = this.getCacheKey(absoluteURL);
        try {
            String dataURI = (String)this.cache.get(cacheKey);
            if (dataURI == null) {
                DiffException failure = (DiffException)this.failureCache.get(cacheKey);
                if (failure != null) {
                    throw failure;
                }
                dataURI = this.convert(absoluteURL);
                this.cache.set(cacheKey, (Object)dataURI);
            }
            return dataURI;
        }
        catch (IOException | URISyntaxException e) {
            DiffException diffException = new DiffException("Failed to convert [" + url + "] to data URI.", (Throwable)e);
            this.failureCache.set(cacheKey, (Object)diffException);
            throw diffException;
        }
    }

    private String convert(URL url) throws IOException, URISyntaxException {
        if (!this.urlSecurityManager.isDomainTrusted(url)) {
            throw new IOException(String.format("The URL [%s] is not trusted.", url));
        }
        ImageDownloader.DownloadResult downloadResult = this.imageDownloader.download(url.toURI());
        return DefaultDataURIConverter.getDataURI(downloadResult.getContentType(), downloadResult.getData());
    }
}

