/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.store.SignatureStore;
import org.xwiki.crypto.store.SignatureStoreException;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Singleton
public class DefaultSignatureStore
implements SignatureStore {
    public static final LocalDocumentReference SIGNATURECLASS = new LocalDocumentReference("Crypto", "SignatureClass");
    public static final String SIGNATURECLASS_PROP_REFERENCE = "reference";
    public static final String SIGNATURECLASS_PROP_SIGNATURE = "signature";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> resolver;
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder base64;

    public void store(EntityReference entity, byte[] signature) throws SignatureStoreException {
        this.checkArguments(entity);
        DocumentReference docRef = this.resolver.resolve((Object)entity.getParent(), new Object[0]);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument document = context.getWiki().getDocument(docRef, context);
            DocumentReference signatureClass = new DocumentReference(SIGNATURECLASS, docRef.getWikiReference());
            String entityReference = entity.getName();
            BaseObject object = document.getXObject(signatureClass, SIGNATURECLASS_PROP_REFERENCE, entityReference);
            if (object == null) {
                object = document.newXObject((EntityReference)SIGNATURECLASS, context);
                object.setStringValue(SIGNATURECLASS_PROP_REFERENCE, entityReference);
            }
            object.setLargeStringValue(SIGNATURECLASS_PROP_SIGNATURE, this.base64.encode(signature, 64));
            context.getWiki().saveDocument(document, context);
        }
        catch (XWikiException e) {
            throw new SignatureStoreException("Error while storing signature for entity [" + String.valueOf(entity) + "]", (Throwable)e);
        }
        catch (IOException e) {
            throw new SignatureStoreException("Error while encoding signature for entity [" + String.valueOf(entity) + "]", (Throwable)e);
        }
    }

    public byte[] retrieve(EntityReference entity) throws SignatureStoreException {
        this.checkArguments(entity);
        DocumentReference docRef = this.resolver.resolve((Object)entity, new Object[0]);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument document = context.getWiki().getDocument(docRef, context);
            DocumentReference signatureClass = new DocumentReference(SIGNATURECLASS, docRef.getWikiReference());
            String entityReference = entity.getName();
            BaseObject object = document.getXObject(signatureClass, SIGNATURECLASS_PROP_REFERENCE, entityReference);
            if (object == null) {
                return null;
            }
            String signature = object.getLargeStringValue(SIGNATURECLASS_PROP_SIGNATURE);
            if (signature == null) {
                return null;
            }
            return this.base64.decode(signature);
        }
        catch (XWikiException e) {
            throw new SignatureStoreException("Error while retrieving signature for entity [" + String.valueOf(entity) + "]", (Throwable)e);
        }
        catch (IOException e) {
            throw new SignatureStoreException("Error while decoding signature for entity [" + String.valueOf(entity) + "]", (Throwable)e);
        }
    }

    private void checkArguments(EntityReference entity) {
        if (entity.getType() != EntityType.BLOCK || entity.getParent() == null || entity.getParent().getType() != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Unsupported reference type [" + String.valueOf(entity.getType()) + "] or parent []. Only blocks of documents are supported.");
        }
    }
}

