/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.script;

import java.nio.charset.StandardCharsets;
import org.xwiki.crypto.pkix.params.CertifiedKeyPair;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.script.AbstractScriptingStore;
import org.xwiki.crypto.store.KeyStore;
import org.xwiki.crypto.store.KeyStoreException;
import org.xwiki.crypto.store.StoreReference;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class ScriptingKeyStore
extends AbstractScriptingStore {
    private KeyStore store;

    ScriptingKeyStore(KeyStore store, StoreReference reference, ContextualAuthorizationManager contextualAuthorizationManager) {
        super(reference, contextualAuthorizationManager);
        this.store = store;
    }

    public void store(CertifiedKeyPair keyPair) throws KeyStoreException, AccessDeniedException {
        this.checkAccess(Right.EDIT);
        this.store.store(this.storeReference, keyPair);
    }

    public void store(CertifiedKeyPair keyPair, String password) throws KeyStoreException, AccessDeniedException {
        this.checkAccess(Right.EDIT);
        this.store.store(this.storeReference, keyPair, password.getBytes(StandardCharsets.UTF_8));
    }

    public CertifiedKeyPair retrieve() throws KeyStoreException, AccessDeniedException {
        this.checkAccess(Right.VIEW);
        return this.store.retrieve(this.storeReference);
    }

    public CertifiedKeyPair retrieve(String password) throws KeyStoreException, AccessDeniedException {
        this.checkAccess(Right.VIEW);
        return this.store.retrieve(this.storeReference, password.getBytes(StandardCharsets.UTF_8));
    }

    public CertifiedKeyPair retrieve(CertifiedPublicKey publicKey) throws KeyStoreException, AccessDeniedException {
        this.checkAccess(Right.VIEW);
        return this.store.retrieve(this.storeReference, publicKey);
    }

    public CertifiedKeyPair retrieve(CertifiedPublicKey publicKey, String password) throws KeyStoreException, AccessDeniedException {
        this.checkAccess(Right.VIEW);
        return this.store.retrieve(this.storeReference, publicKey, password.getBytes(StandardCharsets.UTF_8));
    }
}

