/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.script;

import java.util.Collection;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.script.AbstractScriptingStore;
import org.xwiki.crypto.store.CertificateStore;
import org.xwiki.crypto.store.CertificateStoreException;
import org.xwiki.crypto.store.StoreReference;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class ScriptingCertificateStore
extends AbstractScriptingStore {
    private CertificateStore store;

    ScriptingCertificateStore(CertificateStore store, StoreReference reference, ContextualAuthorizationManager contextualAuthorizationManager) {
        super(reference, contextualAuthorizationManager);
        this.store = store;
    }

    public void store(CertifiedPublicKey certificate) throws CertificateStoreException, AccessDeniedException {
        this.checkAccess(Right.EDIT);
        this.store.store(this.storeReference, certificate);
    }

    public CertificateProvider getCertificateProvider() throws CertificateStoreException, AccessDeniedException {
        this.checkAccess(Right.VIEW);
        return this.store.getCertificateProvider(this.storeReference);
    }

    public Collection<CertifiedPublicKey> getAllCertificates() throws CertificateStoreException, AccessDeniedException {
        this.checkAccess(Right.VIEW);
        return this.store.getAllCertificates(this.storeReference);
    }
}

