/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyPair;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.CertificateGeneratorFactory;
import org.xwiki.crypto.pkix.CertifyingSigner;
import org.xwiki.crypto.pkix.X509ExtensionBuilder;
import org.xwiki.crypto.pkix.params.CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.CertificateParameters;
import org.xwiki.crypto.pkix.params.CertifiedKeyPair;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.pkix.params.x509certificate.DistinguishedName;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.extension.ExtendedKeyUsages;
import org.xwiki.crypto.pkix.params.x509certificate.extension.KeyUsage;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509DnsName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509GeneralName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509IpAddress;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Rfc822Name;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;

@Component(roles={RSACryptoHelper.class})
@Singleton
public class RSACryptoHelper {
    @Inject
    private Provider<X509ExtensionBuilder> extensionBuilder;
    @Inject
    @Named(value="X509")
    private CertificateGeneratorFactory certificateGeneratorFactory;
    @Inject
    @Named(value="SHA256withRSAEncryption")
    private SignerFactory signerFactory;

    public CertifiedPublicKey issueCertificate(CertifiedKeyPair issuer, PublicKeyParameters publicKey, String dn, int validity, List<X509GeneralName> subjectAltName) throws IOException, GeneralSecurityException {
        X509CertificateParameters params;
        X509ExtensionBuilder builder = ((X509ExtensionBuilder)this.extensionBuilder.get()).addKeyUsage(EnumSet.of(KeyUsage.digitalSignature, KeyUsage.dataEncipherment));
        if (subjectAltName != null) {
            params = new X509CertificateParameters(((X509ExtensionBuilder)this.extensionBuilder.get()).addSubjectAltName(false, subjectAltName.toArray(new X509GeneralName[0])).build());
            HashSet<String> extUsage = new HashSet<String>();
            for (X509GeneralName genName : subjectAltName) {
                if (genName instanceof X509Rfc822Name) {
                    extUsage.add("1.3.6.1.5.5.7.3.4");
                } else if (genName instanceof X509DnsName || genName instanceof X509IpAddress) {
                    extUsage.add("1.3.6.1.5.5.7.3.1");
                    extUsage.add("1.3.6.1.5.5.7.3.2");
                }
                builder.addExtendedKeyUsage(false, new ExtendedKeyUsages(extUsage));
            }
        } else {
            params = new X509CertificateParameters();
        }
        return this.certificateGeneratorFactory.getInstance((Signer)CertifyingSigner.getInstance((boolean)true, (CertifiedKeyPair)issuer, (SignerFactory)this.signerFactory), (CertificateGenerationParameters)new X509CertificateGenerationParameters(validity, builder.build())).generate((PrincipalIndentifier)new DistinguishedName((Object)dn), publicKey, (CertificateParameters)params);
    }

    public CertifiedKeyPair issueRootCACertificate(AsymmetricKeyPair keyPair, String dn, int validity) throws IOException, GeneralSecurityException {
        return new CertifiedKeyPair(keyPair.getPrivate(), this.certificateGeneratorFactory.getInstance(this.signerFactory.getInstance(true, (CipherParameters)keyPair.getPrivate()), (CertificateGenerationParameters)new X509CertificateGenerationParameters(validity, ((X509ExtensionBuilder)this.extensionBuilder.get()).addBasicConstraints(true).addKeyUsage(true, EnumSet.of(KeyUsage.keyCertSign, KeyUsage.cRLSign)).build())).generate((PrincipalIndentifier)new DistinguishedName((Object)dn), keyPair.getPublic(), (CertificateParameters)new X509CertificateParameters()));
    }

    public CertifiedPublicKey issueIntermediateCertificate(CertifiedKeyPair issuer, PublicKeyParameters publicKey, String dn, int validity) throws IOException, GeneralSecurityException {
        return this.certificateGeneratorFactory.getInstance((Signer)CertifyingSigner.getInstance((boolean)true, (CertifiedKeyPair)issuer, (SignerFactory)this.signerFactory), (CertificateGenerationParameters)new X509CertificateGenerationParameters(validity, ((X509ExtensionBuilder)this.extensionBuilder.get()).addBasicConstraints(0).addKeyUsage(EnumSet.of(KeyUsage.keyCertSign, KeyUsage.cRLSign)).build())).generate((PrincipalIndentifier)new DistinguishedName((Object)dn), publicKey, (CertificateParameters)new X509CertificateParameters());
    }

    public boolean checkX509CertificateChainValidity(Collection<CertifiedPublicKey> chain, Date date) {
        if (chain == null || chain.isEmpty()) {
            return false;
        }
        Date checkDate = date != null ? date : new Date();
        boolean rootExpected = true;
        for (CertifiedPublicKey cert : chain) {
            if (!(cert instanceof X509CertifiedPublicKey)) {
                return false;
            }
            if (rootExpected) {
                if (!((X509CertifiedPublicKey)cert).isRootCA()) {
                    return false;
                }
                rootExpected = false;
            }
            if (((X509CertifiedPublicKey)cert).isValidOn(checkDate)) continue;
            return false;
        }
        return true;
    }
}

