/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.filters.internal;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;

public class SetCharacterEncodingFilter
implements Filter {
    protected String encoding = null;
    protected FilterConfig filterConfig = null;
    protected boolean ignore = true;

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String selectedEncoding;
        if ((this.ignore || request.getCharacterEncoding() == null) && (selectedEncoding = this.selectEncoding(request)) != null) {
            request.setCharacterEncoding(selectedEncoding);
        }
        response.setCharacterEncoding(this.encoding);
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
        String value = filterConfig.getInitParameter("ignore");
        this.ignore = value == null ? true : (value.equalsIgnoreCase("true") ? true : value.equalsIgnoreCase("yes"));
    }

    protected String selectEncoding(ServletRequest request) {
        return this.encoding;
    }
}

