/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.filters.internal;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xwiki.container.servlet.filters.SavedRequestManager;

public class SavedRequestRestorerFilter
implements Filter {
    private static final Pattern SAVED_REQUEST_REGEXP = Pattern.compile("(?:^|&)" + SavedRequestManager.getSavedRequestIdentifier() + "=([^&]++)");
    private static final String ATTRIBUTE_APPLIED = SavedRequestRestorerFilter.class.getName() + ".applied";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object filteredRequest = request;
        if (request instanceof HttpServletRequest && !Boolean.valueOf((String)request.getAttribute(ATTRIBUTE_APPLIED)).booleanValue()) {
            SavedRequestManager.SavedRequest savedRequest = this.getSavedRequest((HttpServletRequest)request);
            filteredRequest = new SavedRequestWrapper((HttpServletRequest)request, savedRequest);
            filteredRequest.setAttribute(ATTRIBUTE_APPLIED, (Object)"true");
        }
        chain.doFilter(filteredRequest, response);
        filteredRequest.removeAttribute(ATTRIBUTE_APPLIED);
    }

    public void destroy() {
    }

    protected SavedRequestManager.SavedRequest getSavedRequest(HttpServletRequest request) {
        SavedRequestManager.SavedRequest savedRequest;
        HttpSession session;
        Map savedRequests;
        String savedRequestId = null;
        Matcher m = SAVED_REQUEST_REGEXP.matcher(StringUtils.defaultString((String)request.getQueryString()));
        if (m.find()) {
            savedRequestId = m.group(1);
        }
        if (!StringUtils.isEmpty(savedRequestId) && (savedRequests = (Map)(session = request.getSession()).getAttribute(SavedRequestManager.getSavedRequestKey())) != null && (savedRequest = (SavedRequestManager.SavedRequest)savedRequests.get(savedRequestId)) != null && Strings.CS.equals(savedRequest.getRequestUrl(), request.getRequestURL().toString())) {
            savedRequests.remove(savedRequestId);
            return savedRequest;
        }
        return null;
    }

    public static class SavedRequestWrapper
    extends HttpServletRequestWrapper {
        private SavedRequestManager.SavedRequest savedRequest;

        public SavedRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public SavedRequestWrapper(HttpServletRequest newRequest, SavedRequestManager.SavedRequest savedRequest) {
            super(newRequest);
            this.savedRequest = savedRequest;
        }

        public String getParameter(String name) {
            String value = super.getParameter(name);
            if (value == null && this.savedRequest != null) {
                value = this.savedRequest.getParameter(name);
            }
            return value;
        }

        public String[] getParameterValues(String name) {
            String[] values = super.getParameterValues(name);
            if (values == null && this.savedRequest != null) {
                values = this.savedRequest.getParameterValues(name);
            }
            return values;
        }

        public Map<String, String[]> getParameterMap() {
            if (this.savedRequest == null) {
                return super.getParameterMap();
            }
            HashMap<String, String[]> map = new HashMap<String, String[]>(this.savedRequest.getParameterMap());
            map.putAll(super.getParameterMap());
            return Collections.unmodifiableMap(map);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.getParameterMap().keySet());
        }
    }
}

