/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.filters.internal;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.url.URLSecurityManager;

public class SafeRedirectFilter
implements Filter {
    private URLSecurityManager urlSecurityManager;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object filteredResponse = response;
        if (filteredResponse instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)filteredResponse;
            filteredResponse = new SafeRedirectResponse(this.urlSecurityManager, httpResponse);
        }
        chain.doFilter(request, filteredResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ComponentManager rootComponentManager = (ComponentManager)filterConfig.getServletContext().getAttribute(ComponentManager.class.getName());
        try {
            this.urlSecurityManager = (URLSecurityManager)rootComponentManager.getInstance(URLSecurityManager.class);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to access configuration", (Throwable)e);
        }
    }

    public class SafeRedirectResponse
    extends HttpServletResponseWrapper {
        private static final Logger LOGGER = LoggerFactory.getLogger(SafeRedirectResponse.class);
        private final URLSecurityManager urlSecurityManager;

        public SafeRedirectResponse(URLSecurityManager urlSecurityManager, HttpServletResponse response) {
            super(response);
            this.urlSecurityManager = urlSecurityManager;
        }

        public void sendRedirect(String location) throws IOException {
            if (StringUtils.isNotBlank((CharSequence)location)) {
                try {
                    URI uri = this.urlSecurityManager.parseToSafeURI(location);
                    super.sendRedirect(uri.toString());
                }
                catch (SecurityException | URISyntaxException e) {
                    LOGGER.warn("Possible phishing attack, attempting to redirect to [{}], this request has been blocked. If the request was legitimate, please check the URL security configuration. You might need to add the domain related to this request in the list of trusted domains in the configuration: it can be configured in xwiki.properties in url.trustedDomains.", (Object)location);
                    LOGGER.debug("Original error preventing the redirect: ", (Throwable)e);
                }
            }
        }
    }
}

