/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.filters;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.stability.Unstable;

public final class SavedRequestManager {
    private static final String SAVED_REQUESTS_IDENTIFIER = "srid";
    private static final String SAVED_REQUESTS_KEY = SavedRequest.class.getCanonicalName() + "_SavedRequests";

    private SavedRequestManager() {
    }

    public static String getSavedRequestIdentifier() {
        return SAVED_REQUESTS_IDENTIFIER;
    }

    public static String getSavedRequestKey() {
        return SAVED_REQUESTS_KEY;
    }

    @Deprecated(since="17.0.0RC1")
    public static String saveRequest(javax.servlet.http.HttpServletRequest request) {
        return SavedRequestManager.saveRequest(JakartaServletBridge.toJakarta((javax.servlet.http.HttpServletRequest)request));
    }

    @Unstable
    public static String saveRequest(HttpServletRequest request) {
        String key;
        HttpSession session = request.getSession();
        HashMap<String, SavedRequest> savedRequests = (HashMap<String, SavedRequest>)session.getAttribute(SavedRequestManager.getSavedRequestKey());
        if (savedRequests == null) {
            savedRequests = new HashMap<String, SavedRequest>();
            session.setAttribute(SavedRequestManager.getSavedRequestKey(), savedRequests);
        }
        SavedRequest savedRequest = new SavedRequest(request);
        while (savedRequests.containsKey(key = RandomStringUtils.secure().nextAlphanumeric(8))) {
        }
        savedRequests.put(key, savedRequest);
        return key;
    }

    @Deprecated(since="17.0.0RC1")
    public static String getOriginalUrl(javax.servlet.http.HttpServletRequest request) {
        return SavedRequestManager.getOriginalUrl(JakartaServletBridge.toJakarta((javax.servlet.http.HttpServletRequest)request));
    }

    @Unstable
    public static String getOriginalUrl(HttpServletRequest request) {
        SavedRequest savedRequest;
        String identifier;
        HttpSession session = request.getSession();
        Map savedRequests = (Map)session.getAttribute(SavedRequestManager.getSavedRequestKey());
        if (savedRequests != null && !StringUtils.isEmpty((CharSequence)(identifier = request.getParameter(SavedRequestManager.getSavedRequestIdentifier()))) && (savedRequest = (SavedRequest)savedRequests.get(request.getParameter(SavedRequestManager.getSavedRequestIdentifier()))) != null) {
            return savedRequest.getRequestUrl() + "?srid=" + identifier;
        }
        return null;
    }

    public static class SavedRequest
    implements Serializable {
        private static final long serialVersionUID = 8779129900717599986L;
        private Map<String, String[]> parameters;
        private String requestUrl;

        @Deprecated(since="17.0.0RC1")
        public SavedRequest(javax.servlet.http.HttpServletRequest request) {
            this(JakartaServletBridge.toJakarta((javax.servlet.http.HttpServletRequest)request));
        }

        @Unstable
        public SavedRequest(HttpServletRequest request) {
            this.parameters = new HashMap<String, String[]>(request.getParameterMap());
            this.requestUrl = request.getRequestURL().toString();
        }

        public String getParameter(String name) {
            String[] values = this.parameters.get(name);
            if (values != null && values.length > 0) {
                return values[0];
            }
            return null;
        }

        public String[] getParameterValues(String name) {
            return this.parameters.get(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameters;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }
    }
}

