/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.internal.script;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.container.Session;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class ScriptSession
implements Session {
    private static final String KEY_SAFEATTRIBUTES = ScriptSession.class.getName();
    private final Session session;
    private final ContextualAuthorizationManager authorization;

    public ScriptSession(Session session, ContextualAuthorizationManager authorization) {
        this.session = session;
        this.authorization = authorization;
    }

    public Object getSafeAttribute(String name) {
        Map safeAttributes = (Map)this.session.getAttribute(KEY_SAFEATTRIBUTES);
        return safeAttributes != null ? safeAttributes.get(name) : null;
    }

    public void setSafeAttribute(String name, Object value) {
        ConcurrentHashMap<String, Object> safeSession = (ConcurrentHashMap<String, Object>)this.session.getAttribute(KEY_SAFEATTRIBUTES);
        if (safeSession == null) {
            safeSession = new ConcurrentHashMap<String, Object>();
            this.session.setAttribute(KEY_SAFEATTRIBUTES, safeSession);
        }
        safeSession.put(name, value);
    }

    public void removeSafeAttribute(String name) {
        Map safeSession = (Map)this.session.getAttribute(KEY_SAFEATTRIBUTES);
        if (safeSession != null) {
            safeSession.remove(name);
        }
    }

    public Enumeration<String> getSafeAttributeNames() {
        Map safeSession = (Map)this.session.getAttribute(KEY_SAFEATTRIBUTES);
        return safeSession != null ? Collections.enumeration(safeSession.keySet()) : Collections.emptyEnumeration();
    }

    @Override
    public Object getAttribute(String name) {
        return this.authorization.hasAccess(Right.PROGRAM) ? this.session.getAttribute(name) : this.getSafeAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.authorization.hasAccess(Right.PROGRAM) ? this.session.getAttributeNames() : this.getSafeAttributeNames();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            this.session.setAttribute(name, value);
        } else {
            this.setSafeAttribute(name, value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            this.session.removeAttribute(name);
        } else {
            this.removeSafeAttribute(name);
        }
    }
}

