/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.internal.script;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.container.Request;
import org.xwiki.container.wrap.WrappingRequest;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class ScriptRequest
extends WrappingRequest {
    private static final Set<String> READ_ONLY_ATTRIBUTES = Set.of(Request.ATTRIBUTE_EFFECTIVE_AUTHOR);
    private static final String KEY_SAFEATTRIBUTES = ScriptRequest.class.getName() + "#attributes";
    private final ContextualAuthorizationManager authorization;

    public ScriptRequest(Request request, ContextualAuthorizationManager authorization) {
        super(request);
        this.authorization = authorization;
    }

    @Override
    public Request getRequest() {
        return this.authorization.hasAccess(Right.PROGRAM) ? super.getRequest() : null;
    }

    public Object getSafeAttribute(String name) {
        Map safeAttributes = (Map)this.request.getAttribute(KEY_SAFEATTRIBUTES);
        return safeAttributes != null ? safeAttributes.get(name) : null;
    }

    public void setSafeAttribute(String name, Object value) {
        if (!READ_ONLY_ATTRIBUTES.contains(name) || this.authorization.hasAccess(Right.PROGRAM)) {
            ConcurrentHashMap<String, Object> safeSession = (ConcurrentHashMap<String, Object>)this.request.getAttribute(KEY_SAFEATTRIBUTES);
            if (safeSession == null) {
                safeSession = new ConcurrentHashMap<String, Object>();
                this.request.setAttribute(KEY_SAFEATTRIBUTES, safeSession);
            }
            safeSession.put(name, value);
        }
    }

    public void removeSafeAttribute(String name) {
        Map safeSession;
        if ((!READ_ONLY_ATTRIBUTES.contains(name) || this.authorization.hasAccess(Right.PROGRAM)) && (safeSession = (Map)this.request.getAttribute(KEY_SAFEATTRIBUTES)) != null) {
            safeSession.remove(name);
        }
    }

    public Enumeration<String> getSafeAttributeNames() {
        Map safeSession = (Map)this.request.getAttribute(KEY_SAFEATTRIBUTES);
        return safeSession != null ? Collections.enumeration(safeSession.keySet()) : Collections.emptyEnumeration();
    }

    @Override
    public Object getAttribute(String name) {
        return this.authorization.hasAccess(Right.PROGRAM) ? this.request.getAttribute(name) : this.getSafeAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.authorization.hasAccess(Right.PROGRAM) ? this.request.getAttributeNames() : this.getSafeAttributeNames();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            this.request.setAttribute(name, value);
        } else {
            this.setSafeAttribute(name, value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            this.request.removeAttribute(name);
        } else {
            this.removeSafeAttribute(name);
        }
    }
}

