/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.internal.AbstractXWikiPreferencesConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;

@Component
@Named(value="space")
@Singleton
public class SpacePreferencesConfigurationSource
extends AbstractXWikiPreferencesConfigurationSource {
    static final String DOCUMENT_NAME = "WebPreferences";
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    @Override
    protected String getCacheId() {
        return "configuration.document.space";
    }

    @Override
    protected String getCacheKeyPrefix() {
        DocumentReference currentDocumentReference = this.documentAccessBridge.getCurrentDocumentReference();
        if (currentDocumentReference != null) {
            return (String)this.referenceSerializer.serialize(currentDocumentReference.getParent(), new Object[0]);
        }
        return null;
    }

    @Override
    protected DocumentReference getDocumentReference() {
        DocumentReference currentDocumentReference = this.documentAccessBridge.getCurrentDocumentReference();
        if (currentDocumentReference != null) {
            return new DocumentReference(DOCUMENT_NAME, (SpaceReference)currentDocumentReference.getParent());
        }
        return null;
    }
}

