/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.internal.CommonsConfigurationSource;
import org.xwiki.environment.Environment;

@Component
@Named(value="permanent")
@Singleton
public class PermanentConfigurationSource
extends CommonsConfigurationSource
implements Initializable {
    private static final String XWIKI_PROPERTIES_FILE = "configuration.properties";
    @Inject
    private Environment environment;
    private FileBasedConfigurationBuilder<PropertiesConfiguration> builder;

    public void initialize() throws InitializationException {
        this.setConfiguration(this.loadConfiguration());
    }

    private Configuration loadConfiguration() throws InitializationException {
        File permanentDirectory = this.environment.getPermanentDirectory();
        File permanentConfiguration = new File(permanentDirectory, XWIKI_PROPERTIES_FILE).getAbsoluteFile();
        if (!permanentConfiguration.exists()) {
            try {
                FileUtils.write((File)permanentConfiguration, (CharSequence)"", (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new InitializationException("Failed to create the file [" + String.valueOf(permanentConfiguration) + "]", (Throwable)e);
            }
        }
        try {
            this.builder = new Configurations().propertiesBuilder(permanentConfiguration);
            return (Configuration)this.builder.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new InitializationException("Failed to create the Configuration for file [" + String.valueOf(permanentConfiguration) + "]", (Throwable)e);
        }
    }

    private void addProperty(String key, Object value) {
        if (value != null) {
            Class<?> valueClass = value.getClass();
            Object convertedValue = value;
            if (valueClass != String.class && !List.class.isAssignableFrom(valueClass) && !Properties.class.isAssignableFrom(valueClass)) {
                convertedValue = this.converterManager.convert(String.class, value);
            }
            this.getConfiguration().addProperty(key, convertedValue);
        }
    }

    public void setProperty(String key, Object value) throws ConfigurationSaveException {
        this.lock.writeLock().lock();
        try {
            this.getConfiguration().clearProperty(key);
            this.addProperty(key, value);
            this.save();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setProperties(Map<String, Object> properties) throws ConfigurationSaveException {
        this.lock.writeLock().lock();
        try {
            this.getConfiguration().clear();
            properties.forEach(this::addProperty);
            this.save();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void save() throws ConfigurationSaveException {
        try {
            this.builder.save();
        }
        catch (ConfigurationException e) {
            throw new ConfigurationSaveException("Failed to save the configuration file", (Throwable)e);
        }
    }
}

