/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal.bridge;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.component.wiki.internal.WikiComponentConstants;
import org.xwiki.component.wiki.internal.bridge.ContentParser;
import org.xwiki.component.wiki.internal.bridge.WikiComponentBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultWikiComponentBridge
implements WikiComponentConstants,
WikiComponentBridge {
    @Inject
    protected Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ContentParser renderingBridge;
    @Inject
    private DocumentAuthorizationManager authorization;

    @Override
    public Syntax getSyntax(DocumentReference reference) throws WikiComponentException {
        XWikiDocument componentDocument = this.getDocument(reference);
        return componentDocument.getSyntax();
    }

    @Override
    public Type getRoleType(DocumentReference reference) throws WikiComponentException {
        Type roleType;
        BaseObject componentObject = this.getComponentObject(reference);
        String role = componentObject.getStringValue("roleType");
        try {
            roleType = ReflectionUtils.unserializeType((String)role, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new WikiComponentException(String.format("The role type [%s] does not exist", role), e);
        }
        return roleType;
    }

    @Override
    public String getRoleHint(DocumentReference reference) throws WikiComponentException {
        BaseObject componentObject = this.getComponentObject(reference);
        return (String)StringUtils.defaultIfEmpty((CharSequence)componentObject.getStringValue("roleHint"), (CharSequence)"default");
    }

    @Override
    public DocumentReference getAuthorReference(DocumentReference reference) throws WikiComponentException {
        XWikiDocument componentDocument = this.getDocument(reference);
        return componentDocument.getAuthorReference();
    }

    @Override
    public WikiComponentScope getScope(DocumentReference reference) throws WikiComponentException {
        BaseObject componentObject = this.getComponentObject(reference);
        return WikiComponentScope.fromString(componentObject.getStringValue("scope"));
    }

    @Override
    public int getRoleTypePriority(DocumentReference reference) throws WikiComponentException {
        BaseObject componentObject = this.getComponentObject(reference);
        return componentObject.getIntValue("roleTypePriority", 1000);
    }

    @Override
    public int getRoleHintPriority(DocumentReference reference) throws WikiComponentException {
        BaseObject componentObject = this.getComponentObject(reference);
        return componentObject.getIntValue("roleHintPriority", 1000);
    }

    @Override
    public Map<String, XDOM> getHandledMethods(DocumentReference reference) throws WikiComponentException {
        HashMap<String, XDOM> handledMethods = new HashMap<String, XDOM>();
        XWikiDocument componentDocument = this.getDocument(reference);
        if (componentDocument.getObjectNumbers("XWiki.ComponentMethodClass") > 0) {
            for (BaseObject method : componentDocument.getObjects("XWiki.ComponentMethodClass")) {
                if (StringUtils.isBlank((CharSequence)method.getStringValue("name"))) continue;
                handledMethods.put(method.getStringValue("name"), this.renderingBridge.parse(method.getStringValue("code"), this.getSyntax(reference), (EntityReference)reference));
            }
        }
        return handledMethods;
    }

    @Override
    public List<Class<?>> getDeclaredInterfaces(DocumentReference reference) throws WikiComponentException {
        ArrayList interfaces = new ArrayList();
        XWikiDocument componentDocument = this.getDocument(reference);
        if (componentDocument.getObjectNumbers("XWiki.ComponentInterfaceClass") > 0) {
            for (BaseObject iface : componentDocument.getObjects("XWiki.ComponentInterfaceClass")) {
                if (StringUtils.isBlank((CharSequence)iface.getStringValue("name"))) continue;
                try {
                    Class<?> implemented = Class.forName(iface.getStringValue("name"));
                    interfaces.add(implemented);
                }
                catch (Exception e) {
                    this.logger.warn("Interface [{}] not found, declared for wiki component [{}]", (Object)iface.getStringValue("name"), (Object)componentDocument.getDocumentReference());
                }
            }
        }
        return interfaces;
    }

    @Override
    public Map<String, ComponentDescriptor> getDependencies(DocumentReference reference) throws WikiComponentException {
        HashMap<String, ComponentDescriptor> dependencies = new HashMap<String, ComponentDescriptor>();
        XWikiDocument componentDocument = this.getDocument(reference);
        if (componentDocument.getObjectNumbers("XWiki.ComponentDependencyClass") > 0) {
            for (BaseObject dependency : componentDocument.getObjects("XWiki.ComponentDependencyClass")) {
                try {
                    DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
                    cd.setRoleType(ReflectionUtils.unserializeType((String)dependency.getStringValue("roleType"), (ClassLoader)Thread.currentThread().getContextClassLoader()));
                    cd.setRoleHint(dependency.getStringValue("roleHint"));
                    dependencies.put(dependency.getStringValue("bindingName"), (ComponentDescriptor)cd);
                }
                catch (Exception e) {
                    this.logger.warn("Interface [{}] not found, declared as dependency for wiki component [{}]", (Object)dependency.getStringValue("roleType"), (Object)componentDocument.getDocumentReference());
                }
            }
        }
        return dependencies;
    }

    @Override
    public boolean hasProgrammingRights(DocumentReference reference) throws WikiComponentException {
        XWikiDocument document = this.getDocument(reference);
        return this.authorization.hasAccess(Right.PROGRAM, null, document.getAuthorReference(), document.getDocumentReference());
    }

    private BaseObject getComponentObject(DocumentReference reference) throws WikiComponentException {
        XWikiDocument componentDocument = this.getDocument(reference);
        BaseObject componentObject = componentDocument.getObject("XWiki.ComponentClass");
        if (componentObject == null) {
            throw new WikiComponentException(String.format("No component object could be found in document [%s]", reference));
        }
        return componentObject;
    }

    private XWikiDocument getDocument(DocumentReference reference) throws WikiComponentException {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            return xcontext.getWiki().getDocument(reference, xcontext);
        }
        catch (XWikiException e) {
            throw new WikiComponentException(String.format("Failed to retrieve the document [%s]", reference), e);
        }
    }
}

