/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentBuilder;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.WikiComponentManagerEventListenerHelper;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="defaultWikiComponentManagerEventListener")
@Singleton
public class DefaultWikiComponentManagerEventListener
extends AbstractEventListener {
    public static final String EVENT_LISTENER_NAME = "defaultWikiComponentManagerEventListener";
    @Inject
    private Logger logger;
    @Inject
    private List<WikiComponentBuilder> wikiComponentProviders;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private WikiComponentManagerEventListenerHelper wikiComponentManagerEventListenerHelper;

    public DefaultWikiComponentManagerEventListener() {
        super(EVENT_LISTENER_NAME, new Event[]{new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new ApplicationReadyEvent(), new WikiReadyEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (source instanceof DocumentModelBridge) {
            DocumentModelBridge document = (DocumentModelBridge)source;
            DocumentReference documentReference = document.getDocumentReference();
            if (event instanceof DocumentCreatedEvent || event instanceof DocumentUpdatedEvent) {
                this.registerDocumentComponents(document.getDocumentReference());
            } else if (event instanceof DocumentDeletedEvent) {
                this.wikiComponentManagerEventListenerHelper.unregisterComponents((EntityReference)documentReference);
            }
        } else if (event instanceof ApplicationReadyEvent || event instanceof WikiReadyEvent) {
            this.registerAllDocumentComponents();
        }
    }

    private void registerAllDocumentComponents() {
        try {
            this.wikiComponentProviders = this.componentManager.getInstanceList(WikiComponentBuilder.class);
            for (WikiComponentBuilder provider : this.wikiComponentProviders) {
                for (DocumentReference reference : provider.getDocumentReferences()) {
                    try {
                        List<WikiComponent> components = provider.buildComponents(reference);
                        this.wikiComponentManagerEventListenerHelper.registerComponentList(components);
                    }
                    catch (WikiComponentException e) {
                        this.logger.warn("Failed to build the wiki component located in the document [{}]: {}", (Object)reference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                }
            }
        }
        catch (ComponentLookupException e) {
            this.logger.warn(String.format("Unable to get a list of registered WikiComponentBuilder: %s", new Object[]{e}));
        }
    }

    private void registerDocumentComponents(DocumentReference documentReference) {
        this.wikiComponentManagerEventListenerHelper.unregisterComponents((EntityReference)documentReference);
        for (WikiComponentBuilder provider : this.wikiComponentProviders) {
            if (!provider.getDocumentReferences().contains(documentReference)) continue;
            try {
                List<WikiComponent> components = provider.buildComponents(documentReference);
                this.wikiComponentManagerEventListenerHelper.registerComponentList(components);
            }
            catch (WikiComponentException e) {
                this.logger.warn("Failed to create wiki component(s) for document [{}]: {}", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            break;
        }
    }
}

