/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentManager;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.component.wiki.internal.WikiComponentManagerContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultWikiComponentManager
implements WikiComponentManager {
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager rootComponentManager;
    @Inject
    private WikiComponentManagerContext wikiComponentManagerContext;
    private Map<EntityReference, List<WikiComponent>> registeredComponents = new ConcurrentHashMap<EntityReference, List<WikiComponent>>();

    @Override
    public void registerWikiComponent(WikiComponent component) throws WikiComponentException {
        DocumentReference currentUserReference = this.wikiComponentManagerContext.getCurrentUserReference();
        EntityReference currentEntityReference = this.wikiComponentManagerContext.getCurrentEntityReference();
        try {
            Type roleType = component.getRoleType();
            Class roleTypeClass = ReflectionUtils.getTypeClass((Type)roleType);
            ComponentDescriptor componentDescriptor = this.createComponentDescriptor(roleType, component);
            this.wikiComponentManagerContext.setCurrentUserReference(component.getAuthorReference());
            this.wikiComponentManagerContext.setCurrentEntityReference(component.getEntityReference());
            if (this.isInitializable(component.getClass().getInterfaces())) {
                try {
                    ((Initializable)component).initialize();
                }
                catch (InitializationException e) {
                    this.logger.error("Failed to initialize wiki component", (Throwable)e);
                }
            }
            this.getComponentManager(component.getScope()).registerComponent(componentDescriptor, roleTypeClass.cast(component));
            this.cacheWikiComponent(component);
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException(String.format("Failed to find a component manager for scope [%s] wiki component registration failed", new Object[]{component.getScope()}), e);
        }
        catch (ComponentRepositoryException e) {
            throw new WikiComponentException("Failed to register wiki component against component repository", e);
        }
        finally {
            this.wikiComponentManagerContext.setCurrentUserReference(currentUserReference);
            this.wikiComponentManagerContext.setCurrentEntityReference(currentEntityReference);
        }
    }

    private void cacheWikiComponent(WikiComponent component) {
        List<WikiComponent> wikiComponents = this.registeredComponents.get(component.getEntityReference());
        if (wikiComponents == null) {
            wikiComponents = new ArrayList<WikiComponent>();
            this.registeredComponents.put(component.getEntityReference(), wikiComponents);
        }
        if (!wikiComponents.contains(component)) {
            wikiComponents.add(component);
        }
    }

    @Override
    public void unregisterWikiComponents(DocumentReference reference) throws WikiComponentException {
        this.unregisterWikiComponents((EntityReference)reference);
    }

    @Override
    public void unregisterWikiComponents(EntityReference reference) throws WikiComponentException {
        List<WikiComponent> wikiComponents = this.registeredComponents.get(reference);
        if (wikiComponents != null) {
            Iterator<WikiComponent> iterator = wikiComponents.iterator();
            while (iterator.hasNext()) {
                this.unregisterWikiComponent(iterator);
            }
            wikiComponents = this.registeredComponents.get(reference);
            if (wikiComponents.isEmpty()) {
                this.registeredComponents.remove(reference);
            }
        }
    }

    private void unregisterWikiComponent(Iterator<WikiComponent> iterator) throws WikiComponentException {
        WikiComponent wikiComponent = iterator.next();
        DocumentReference currentUserReference = this.wikiComponentManagerContext.getCurrentUserReference();
        EntityReference currentEntityReference = this.wikiComponentManagerContext.getCurrentEntityReference();
        try {
            this.wikiComponentManagerContext.setCurrentUserReference(wikiComponent.getAuthorReference());
            this.wikiComponentManagerContext.setCurrentEntityReference(wikiComponent.getEntityReference());
            this.getComponentManager(wikiComponent.getScope()).unregisterComponent(wikiComponent.getRoleType(), wikiComponent.getRoleHint());
            iterator.remove();
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException(String.format("Failed to find a component manager for scope [%s]", new Object[]{wikiComponent.getScope()}), e);
        }
        finally {
            this.wikiComponentManagerContext.setCurrentUserReference(currentUserReference);
            this.wikiComponentManagerContext.setCurrentEntityReference(currentEntityReference);
        }
    }

    private ComponentManager getComponentManager(WikiComponentScope scope) throws ComponentLookupException {
        return switch (scope) {
            case WikiComponentScope.USER -> (ComponentManager)this.rootComponentManager.getInstance(ComponentManager.class, "user");
            case WikiComponentScope.WIKI -> (ComponentManager)this.rootComponentManager.getInstance(ComponentManager.class, "wiki");
            default -> this.rootComponentManager;
        };
    }

    private ComponentDescriptor createComponentDescriptor(Type roleType, WikiComponent component) {
        DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
        cd.setRoleType(roleType);
        cd.setRoleHint(component.getRoleHint());
        cd.setImplementation(component.getClass());
        cd.setRoleHintPriority(component.getRoleHintPriority());
        cd.setRoleTypePriority(component.getRoleTypePriority());
        return cd;
    }

    private boolean isInitializable(Class<?>[] interfaces) {
        for (Class<?> iface : interfaces) {
            if (!Initializable.class.equals(iface)) continue;
            return true;
        }
        return false;
    }
}

