/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentRuntimeException;
import org.xwiki.component.wiki.internal.DefaultWikiComponent;
import org.xwiki.component.wiki.internal.WikiComponentMethodExecutor;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.security.authorization.AuthorExecutor;

public class DefaultWikiComponentInvocationHandler
implements InvocationHandler {
    private static final String METHOD_CONTEXT_COMPONENT_KEY = "component";
    private final Logger logger = LoggerFactory.getLogger(DefaultWikiComponentInvocationHandler.class);
    private final ComponentManager componentManager;
    private final DefaultWikiComponent wikiComponent;
    private final AuthorExecutor authorExecutor;

    public DefaultWikiComponentInvocationHandler(DefaultWikiComponent wikiComponent, AuthorExecutor authorExecutor, ComponentManager componentManager) {
        this.wikiComponent = wikiComponent;
        this.componentManager = componentManager;
        this.authorExecutor = authorExecutor;
    }

    private void injectComponentDependencies(Map<String, Object> methodContext) {
        for (Map.Entry<String, ComponentDescriptor> dependency : this.wikiComponent.getDependencies().entrySet()) {
            ComponentDescriptor cd = dependency.getValue();
            Class roleTypeClass = ReflectionUtils.getTypeClass((Type)cd.getRoleType());
            Object componentDependency = null;
            try {
                componentDependency = roleTypeClass.isAssignableFrom(List.class) ? this.componentManager.getInstanceList(((ParameterizedType)cd.getRoleType()).getActualTypeArguments()[0]) : (roleTypeClass.isAssignableFrom(Map.class) ? this.componentManager.getInstanceMap(((ParameterizedType)cd.getRoleType()).getActualTypeArguments()[1]) : this.componentManager.getInstance(cd.getRoleType(), cd.getRoleHint()));
            }
            catch (ComponentLookupException e) {
                this.logger.warn(String.format("No component found for role [%s] with hint [%s], declared as dependency for wiki component [%s]", cd.getRoleType().toString(), cd.getRoleHint(), this.wikiComponent.getDocumentReference()));
            }
            methodContext.put(dependency.getKey(), componentDependency);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        if (!this.wikiComponent.getHandledMethods().containsKey(method.getName())) {
            if (method.getDeclaringClass() == Object.class || method.getDeclaringClass() == WikiComponent.class) {
                return method.invoke((Object)this.wikiComponent, args);
            }
            throw new WikiComponentRuntimeException(String.format("You need to add an Object of type [%s] in document [%s] to implement method [%s.%s]", "XWiki.ComponentMethodClass", this.wikiComponent.getDocumentReference(), method.getDeclaringClass().getName(), method.getName()));
        }
        WikiComponentMethodExecutor methodExecutor = (WikiComponentMethodExecutor)this.componentManager.getInstance(WikiComponentMethodExecutor.class);
        HashMap<String, Object> methodContext = new HashMap<String, Object>();
        XDOM xdom = this.wikiComponent.getHandledMethods().get(method.getName());
        methodContext.put(METHOD_CONTEXT_COMPONENT_KEY, proxy);
        this.injectComponentDependencies(methodContext);
        return this.authorExecutor.call(() -> methodExecutor.execute(method, args, this.wikiComponent.getDocumentReference(), xdom, this.wikiComponent.getSyntax(), methodContext), this.wikiComponent.getAuthorReference(), this.wikiComponent.getDocumentReference());
    }
}

