/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentBuilder;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.DefaultWikiComponent;
import org.xwiki.component.wiki.internal.DefaultWikiComponentInvocationHandler;
import org.xwiki.component.wiki.internal.WikiComponentConstants;
import org.xwiki.component.wiki.internal.bridge.WikiComponentBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.AuthorExecutor;

@Component
@Singleton
public class DefaultWikiComponentBuilder
implements WikiComponentBuilder,
WikiComponentConstants {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiComponentBridge componentBridge;
    @Inject
    private AuthorExecutor authorExecutor;

    @Override
    public List<DocumentReference> getDocumentReferences() {
        ArrayList<DocumentReference> results = new ArrayList<DocumentReference>();
        String query = ", BaseObject as obj, StringProperty as role where obj.className=?1 and obj.name=doc.fullName and role.id.id=obj.id and role.id.name=?2 and  (role.value <> '' or (role.value is not null and '' is null))";
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("XWiki.ComponentClass");
        parameters.add("roleType");
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            results.addAll(xcontext.getWiki().getStore().searchDocumentReferences(query, parameters, xcontext));
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to get document references for existing wiki components. Considering there's no wiki component. Root cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return results;
    }

    @Override
    public List<WikiComponent> buildComponents(DocumentReference reference) throws WikiComponentException {
        ArrayList<WikiComponent> components = new ArrayList<WikiComponent>();
        if (!this.componentBridge.hasProgrammingRights(reference)) {
            throw new WikiComponentException("Registering wiki components requires programming rights");
        }
        DefaultWikiComponent rawComponent = new DefaultWikiComponent(reference, this.componentBridge.getAuthorReference(reference), this.componentBridge.getRoleType(reference), this.componentBridge.getRoleHint(reference), this.componentBridge.getScope(reference));
        rawComponent.setRoleTypePriority(this.componentBridge.getRoleTypePriority(reference));
        rawComponent.setRoleHintPriority(this.componentBridge.getRoleHintPriority(reference));
        rawComponent.setHandledMethods(this.componentBridge.getHandledMethods(reference));
        rawComponent.setImplementedInterfaces(this.componentBridge.getDeclaredInterfaces(reference));
        rawComponent.setDependencies(this.componentBridge.getDependencies(reference));
        rawComponent.setSyntax(this.componentBridge.getSyntax(reference));
        DefaultWikiComponentInvocationHandler handler = new DefaultWikiComponentInvocationHandler(rawComponent, this.authorExecutor, this.contextComponentManager);
        ArrayList implementedInterfaces = new ArrayList();
        Class roleTypeClass = ReflectionUtils.getTypeClass((Type)rawComponent.getRoleType());
        implementedInterfaces.add(ReflectionUtils.getTypeClass((Type)roleTypeClass));
        implementedInterfaces.addAll(rawComponent.getImplementedInterfaces());
        implementedInterfaces.addAll(Arrays.asList(rawComponent.getClass().getInterfaces()));
        Class[] implementedInterfacesArray = implementedInterfaces.toArray(new Class[0]);
        WikiComponent component = (WikiComponent)Proxy.newProxyInstance(roleTypeClass.getClassLoader(), implementedInterfacesArray, (InvocationHandler)handler);
        components.add(component);
        return components;
    }
}

