/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart.source.table;

import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Date;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.xwiki.chart.time.TimePeriodType;
import org.xwiki.rendering.internal.macro.chart.source.LocaleConfiguration;
import org.xwiki.rendering.internal.macro.chart.source.table.TableDatasetBuilder;
import org.xwiki.rendering.macro.MacroExecutionException;

public class TableTimeTableXYDatasetBuilder
implements TableDatasetBuilder {
    public static final String TIMEPERIOD_TYPE_PARAM = "time_period";
    private boolean transpose;
    private Date[] dates;
    private String[] seriesNames;
    private TimeTableXYDataset dataset;
    private TimePeriodType timePeriodType = TimePeriodType.SIMPLE;
    private final Map<TimePeriodType, Class<? extends RegularTimePeriod>> timePeriodClasses = new EnumMap<TimePeriodType, Class<? extends RegularTimePeriod>>(TimePeriodType.class){
        private static final long serialVersionUID = 1L;
        {
            this.put(TimePeriodType.MILLISECOND, Millisecond.class);
            this.put(TimePeriodType.SECOND, Second.class);
            this.put(TimePeriodType.MINUTE, Minute.class);
            this.put(TimePeriodType.HOUR, Hour.class);
            this.put(TimePeriodType.DAY, Day.class);
            this.put(TimePeriodType.WEEK, Week.class);
            this.put(TimePeriodType.MONTH, Month.class);
            this.put(TimePeriodType.QUARTER, Quarter.class);
            this.put(TimePeriodType.YEAR, Year.class);
        }
    };
    private LocaleConfiguration localeConfiguration;

    @Override
    public void setNumberOfRows(int numberOfRows) {
        if (this.transpose) {
            this.dates = new Date[numberOfRows];
        } else {
            this.seriesNames = new String[numberOfRows];
        }
    }

    @Override
    public void setNumberOfColumns(int numberOfColumns) {
        if (this.transpose) {
            this.seriesNames = new String[numberOfColumns];
        } else {
            this.dates = new Date[numberOfColumns];
        }
    }

    @Override
    public void setTranspose(boolean transpose) {
        this.transpose = transpose;
    }

    private void setDate(int index, String dateText) throws MacroExecutionException {
        try {
            this.dates[index] = this.localeConfiguration.getDateFormat().parse(StringUtils.trim((String)dateText));
        }
        catch (ParseException e) {
            throw new MacroExecutionException(String.format("Failed to parse date [%s] in time table.", dateText), (Throwable)e);
        }
    }

    @Override
    public void setColumnHeading(int columnIndex, String heading) throws MacroExecutionException {
        if (this.transpose) {
            this.seriesNames[columnIndex] = heading;
        } else {
            this.setDate(columnIndex, heading);
        }
    }

    @Override
    public void setRowHeading(int rowIndex, String heading) throws MacroExecutionException {
        if (this.transpose) {
            this.setDate(rowIndex, heading);
        } else {
            this.seriesNames[rowIndex] = heading;
        }
    }

    private TimePeriod getTimePeriod(int index) {
        Date time = this.dates[index];
        Class<? extends RegularTimePeriod> timePeriodClass = this.timePeriodClasses.get(this.timePeriodType);
        if (timePeriodClass == null) {
            Date start = index == 0 ? new Date(0L) : this.dates[index - 1];
            Date end = time;
            return new SimpleTimePeriod(start, end);
        }
        try {
            Constructor<? extends RegularTimePeriod> constructor = timePeriodClass.getConstructor(Date.class, TimeZone.class, Locale.class);
            return (TimePeriod)constructor.newInstance(time, this.localeConfiguration.getTimeZone(), this.localeConfiguration.getLocale());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, Number value) throws MacroExecutionException {
        TimePeriod period = this.transpose ? this.getTimePeriod(rowIndex) : this.getTimePeriod(columnIndex);
        String series = this.transpose ? this.seriesNames[columnIndex] : this.seriesNames[rowIndex];
        this.dataset.add(period, value, (Comparable)((Object)series), false);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setParameters(Map<String, String> parameters) throws MacroExecutionException {
        String timePeriodTypeString = parameters.get(TIMEPERIOD_TYPE_PARAM);
        if (timePeriodTypeString != null) {
            this.timePeriodType = TimePeriodType.forName((String)timePeriodTypeString);
            if (this.timePeriodType == null) {
                throw new MacroExecutionException(String.format("Invalid time period type [%s].", timePeriodTypeString));
            }
        }
        this.dataset = new TimeTableXYDataset(this.localeConfiguration.getTimeZone(), this.localeConfiguration.getLocale());
    }

    @Override
    public boolean forceColumnHeadings() {
        return this.transpose;
    }

    @Override
    public boolean forceRowHeadings() {
        return !this.transpose;
    }

    @Override
    public void setLocaleConfiguration(LocaleConfiguration localeConfiguration) {
        this.localeConfiguration = localeConfiguration;
    }
}

