/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.internal.script;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.captcha.internal.JCaptchaResourceReference;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.script.service.ScriptService;
import org.xwiki.url.ExtendedURL;

@Component
@Named(value="jcaptcha")
@Singleton
public class JCaptchaInternalScriptService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    private ResourceReferenceSerializer<ResourceReference, ExtendedURL> defaultResourceReferenceSerializer;

    public String getURL(String type, String engine, Map<String, Object> params) {
        ExtendedURL extendedURL;
        if (StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)engine)) {
            return null;
        }
        JCaptchaResourceReference resourceReference = new JCaptchaResourceReference(type, engine);
        if (params != null) {
            for (Map.Entry<String, Object> parameterEntry : params.entrySet()) {
                resourceReference.addParameter(parameterEntry.getKey(), parameterEntry.getValue());
            }
        }
        try {
            extendedURL = (ExtendedURL)this.defaultResourceReferenceSerializer.serialize((ResourceReference)resourceReference);
        }
        catch (SerializeResourceReferenceException | UnsupportedResourceReferenceException e) {
            this.logger.warn("Error while serializing JCaptcha URL for type [{}], engine = [{}]. Root cause = [{}]", new Object[]{type, engine, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return null;
        }
        return extendedURL.serialize();
    }
}

