/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.internal;

import com.octo.captcha.component.sound.wordtosound.AbstractFreeTTSWordToSound;
import com.octo.captcha.module.web.image.ImageToJpegHelper;
import com.octo.captcha.module.web.sound.SoundToWavHelper;
import com.octo.captcha.service.CaptchaService;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.octo.captcha.service.sound.SoundCaptchaService;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.xwiki.captcha.internal.CaptchaServiceManager;
import org.xwiki.captcha.internal.JCaptchaResourceReference;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;

@Component
@Named(value="jcaptcha")
@Singleton
public class JCaptchaResourceReferenceHandler
extends AbstractResourceReferenceHandler<ResourceType> {
    private static final String FREETTS_PROPERTIES_KEY = "freetts.voices";
    private static final String TYPE_IMAGE = "image";
    private static final String TYPE_SOUND = "sound";
    private static final String TYPE_TEXT = "text";
    @Inject
    private CaptchaServiceManager captchaServiceManager;
    @Inject
    private Container container;

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(JCaptchaResourceReference.TYPE);
    }

    public void handle(ResourceReference reference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        try {
            HttpServletRequest request = ((ServletRequest)this.container.getRequest()).getHttpServletRequest();
            HttpServletResponse response = ((ServletResponse)this.container.getResponse()).getHttpServletResponse();
            JCaptchaResourceReference jCaptchaResourceReference = (JCaptchaResourceReference)reference;
            if (System.getProperty(FREETTS_PROPERTIES_KEY) == null) {
                System.setProperty(FREETTS_PROPERTIES_KEY, AbstractFreeTTSWordToSound.defaultVoicePackage);
            }
            CaptchaService captchaService = this.captchaServiceManager.getCaptchaService(jCaptchaResourceReference.getEngine());
            String type = jCaptchaResourceReference.getCaptchaType();
            String id = request.getSession().getId();
            Locale locale = request.getLocale();
            if (type == null) {
                throw new IllegalArgumentException("Missing [type] parameter");
            }
            switch (type) {
                case "image": {
                    ImageToJpegHelper.flushNewCaptchaToResponse((HttpServletRequest)request, (HttpServletResponse)response, null, (ImageCaptchaService)((ImageCaptchaService)captchaService), (String)id, (Locale)locale);
                    break;
                }
                case "sound": {
                    SoundToWavHelper.flushNewCaptchaToResponse((HttpServletRequest)request, (HttpServletResponse)response, null, (SoundCaptchaService)((SoundCaptchaService)captchaService), (String)id, (Locale)locale);
                    break;
                }
                case "text": {
                    response.setContentType("text/plain");
                    response.setCharacterEncoding("UTF-8");
                    response.setHeader("Cache-Control", "no-store");
                    response.setHeader("Pragma", "no-cache");
                    response.setDateHeader("Expires", 0L);
                    String challenge = (String)captchaService.getChallengeForID(id, locale);
                    try (ServletOutputStream responseOutput = response.getOutputStream();){
                        IOUtils.write((String)challenge, (OutputStream)responseOutput, (Charset)Charset.defaultCharset());
                        break;
                    }
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported value [%s] for the [type] parameter", type));
                }
            }
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to handle resource [%s]", JCaptchaResourceReference.TYPE), (Throwable)e);
        }
        chain.handleNext(reference);
    }
}

