/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.bridge.internal;

import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.internal.DocumentContextExecutor;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultDocumentContextExecutor
implements DocumentContextExecutor {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ModelContext modelContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V call(Callable<V> callable, DocumentModelBridge document) throws Exception {
        HashMap<String, Object> backupObjects = new HashMap<String, Object>();
        EntityReference currentWikiReference = this.modelContext.getCurrentEntityReference();
        boolean canPop = false;
        try {
            this.documentAccessBridge.pushDocumentInContext(backupObjects, document);
            canPop = true;
            this.modelContext.setCurrentEntityReference((EntityReference)document.getDocumentReference().getWikiReference());
            V v = callable.call();
            return v;
        }
        finally {
            if (canPop) {
                this.documentAccessBridge.popDocumentFromContext(backupObjects);
                this.modelContext.setCurrentEntityReference(currentWikiReference);
            }
        }
    }
}

