/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.validation.internal.step;

import com.xpn.xwiki.XWikiContext;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.xwiki.attachment.AttachmentAccessWrapper;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.attachment.validation.AttachmentValidationStep;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
@Named(value="size")
public class FileSizeAttachmentValidationStep
implements AttachmentValidationStep {
    public static final String HINT = "size";
    @Inject
    private Provider<XWikiContext> contextProvider;

    public void validate(AttachmentAccessWrapper wrapper) throws AttachmentValidationException {
        long uploadMaxSize = this.getUploadMaxSize();
        if (wrapper.getSize() > uploadMaxSize) {
            throw new AttachmentValidationException("File size too big", Response.Status.REQUEST_ENTITY_TOO_LARGE.getStatusCode(), "attachment.validation.filesize.rejected", List.of(FileUtils.byteCountToDisplaySize((long)uploadMaxSize)), "fileuploadislarge");
        }
    }

    private long getUploadMaxSize() {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        return context.getWiki().getSpacePreferenceAsLong("upload_maxsize", 0x2000000L, context);
    }
}

