/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.validation.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.xwiki.attachment.AttachmentAccessWrapper;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.attachment.validation.AttachmentValidationStep;
import org.xwiki.attachment.validation.AttachmentValidator;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;

@Component
@Singleton
public class DefaultAttachmentValidator
implements AttachmentValidator {
    private static final List<String> KNOWN_STEPS = List.of("size", "mimetype");
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    @Named(value="size")
    private AttachmentValidationStep sizeAttachmentValidationStep;
    @Inject
    @Named(value="mimetype")
    private AttachmentValidationStep mimetypeAttachmentValidationStep;

    public void validateAttachment(AttachmentAccessWrapper wrapper) throws AttachmentValidationException {
        this.sizeAttachmentValidationStep.validate(wrapper);
        this.mimetypeAttachmentValidationStep.validate(wrapper);
        try {
            Map map = this.componentManager.getInstanceMap(AttachmentValidationStep.class);
            for (Map.Entry entry : map.entrySet()) {
                if (KNOWN_STEPS.contains(entry.getKey())) continue;
                ((AttachmentValidationStep)entry.getValue()).validate(wrapper);
            }
        }
        catch (ComponentLookupException e) {
            throw new AttachmentValidationException(String.format("Failed to resolve the [%s] components.", AttachmentValidationStep.class), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "attachment.validation.attachmentValidationStep.error");
        }
    }
}

