/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.validation.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.attachment.validation.AttachmentValidationConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultAttachmentValidationConfiguration
implements AttachmentValidationConfiguration {
    private static final String ATTACHMENT_MIMETYPE_ALLOW_LIST_PROPERTY = "attachment.upload.allowList";
    private static final String ATTACHMENT_MIMETYPE_BLOCK_LIST_PROPERTY = "attachment.upload.blockList";
    @Inject
    @Named(value="attachment.mimetypeRestriction.configurationSource.spaces")
    private ConfigurationSource attachmentConfigurationSource;
    @Inject
    @Named(value="attachment.mimetypeRestriction.wiki")
    private ConfigurationSource wikiConfigurationSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xWikiPropertiesConfigurationSource;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public List<String> getAllowedMimetypes() {
        return this.getPropertyWithFallback("allowedMimetypes", ATTACHMENT_MIMETYPE_ALLOW_LIST_PROPERTY);
    }

    public List<String> getAllowedMimetypes(DocumentReference documentReference) {
        return this.wrapWithScope(documentReference, this::getAllowedMimetypes);
    }

    public List<String> getBlockerMimetypes() {
        return this.getPropertyWithFallback("blockedMimetypes", ATTACHMENT_MIMETYPE_BLOCK_LIST_PROPERTY);
    }

    public List<String> getBlockerMimetypes(DocumentReference documentReference) {
        return this.wrapWithScope(documentReference, this::getBlockerMimetypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxUploadSize(EntityReference entityReference) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiDocument previous = context.getDoc();
        try {
            XWiki wiki = context.getWiki();
            if (entityReference != null) {
                context.setDoc(wiki.getDocument(entityReference, context));
            }
            long l = wiki.getSpacePreferenceAsLong("upload_maxsize", 0x2000000L, context);
            return l;
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to resolve the entity [{}]. Cause: [{}]", (Object)entityReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            long l = 0x2000000L;
            return l;
        }
        finally {
            context.setDoc(previous);
        }
    }

    private List<String> getPropertyWithFallback(String attachmentXObjectProperty, String xWikiPropertiesProperty) {
        return this.get(this.attachmentConfigurationSource, attachmentXObjectProperty).or(() -> this.get(this.wikiConfigurationSource, attachmentXObjectProperty)).or(() -> this.get(this.xWikiPropertiesConfigurationSource, xWikiPropertiesProperty)).orElse(List.of());
    }

    private Optional<List<String>> get(ConfigurationSource attachmentConfigurationSource, String key) {
        List property;
        Optional<Object> result = !attachmentConfigurationSource.containsKey(key) ? Optional.empty() : ((property = (List)attachmentConfigurationSource.getProperty(key)).isEmpty() ? Optional.empty() : Optional.of(property));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> wrapWithScope(DocumentReference documentReference, Supplier<List<String>> supplier) {
        XWikiContext xWikiContext = (XWikiContext)this.contextProvider.get();
        XWikiDocument oldDoc = xWikiContext.getDoc();
        try {
            xWikiContext.setDoc(xWikiContext.getWiki().getDocument(documentReference, xWikiContext));
            List<String> list = supplier.get();
            return list;
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to get document [{}]. Cause: [{}]", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            List<String> list = List.of();
            return list;
        }
        finally {
            xWikiContext.setDoc(oldDoc);
        }
    }
}

