/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.validation;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.attachment.validation.AttachmentValidationConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;

@Component
@Singleton
@Named(value="attachmentValidation")
public class AttachmentValidationScriptService
implements ScriptService {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private Logger logger;

    public List<String> getAllowedMimetypes() {
        return this.getAttachmentValidationConfiguration().map(AttachmentValidationConfiguration::getAllowedMimetypes).orElse(List.of());
    }

    public List<String> getAllowedMimetypes(DocumentReference documentReference) {
        return this.getAttachmentValidationConfiguration().map(attachmentValidationConfiguration -> attachmentValidationConfiguration.getAllowedMimetypes(documentReference)).orElse(List.of());
    }

    public List<String> getBlockerMimetypes() {
        return this.getAttachmentValidationConfiguration().map(AttachmentValidationConfiguration::getBlockerMimetypes).orElse(List.of());
    }

    public List<String> getBlockerMimetypes(DocumentReference documentReference) {
        return this.getAttachmentValidationConfiguration().map(attachmentValidationConfiguration -> attachmentValidationConfiguration.getBlockerMimetypes(documentReference)).orElse(List.of());
    }

    public long getUploadMaxSize(EntityReference entityReference) {
        return this.getAttachmentValidationConfiguration().map(attachmentValidationConfiguration -> attachmentValidationConfiguration.getMaxUploadSize(entityReference)).orElse(0L);
    }

    public long getUploadMaxSize() {
        return this.getUploadMaxSize(null);
    }

    private Optional<AttachmentValidationConfiguration> getAttachmentValidationConfiguration() {
        try {
            AttachmentValidationConfiguration attachmentValidationConfiguration = (AttachmentValidationConfiguration)((ComponentManager)this.componentManager.get()).getInstance(AttachmentValidationConfiguration.class);
            return Optional.of(attachmentValidationConfiguration);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to retrieve an instance of [{}] with hint [default].", (Object)AttachmentValidationConfiguration.class.getName());
            return Optional.empty();
        }
    }
}

