/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.attachment.AttachmentException;
import org.xwiki.attachment.configuration.AttachmentConfiguration;
import org.xwiki.attachment.internal.AttachmentsManager;
import org.xwiki.attachment.refactoring.MoveAttachmentRequest;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Singleton
@Named(value="attachment")
public class AttachmentScriptService
implements ScriptService {
    @Inject
    private AttachmentsManager attachmentsManager;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> xWikiContextProvider;
    @Inject
    private AttachmentConfiguration attachmentConfiguration;
    @Inject
    private Logger logger;

    public MoveAttachmentRequest createMoveRequest(DocumentReference sourceLocation, String sourceName, DocumentReference targetLocation, String targetName, DocumentReference userReference, boolean autoRedirect, boolean updateReferences) {
        MoveAttachmentRequest request = new MoveAttachmentRequest();
        request.setEntityReferences(Collections.singletonList(new AttachmentReference(sourceName, sourceLocation)));
        request.setProperty("destination", new AttachmentReference(targetName, targetLocation));
        request.setProperty("autoRedirect", autoRedirect);
        request.setProperty("updateReferences", updateReferences);
        request.setInteractive(true);
        request.setId(new String[]{"refactoring", "moveAttachment", String.format("%d-%d", System.currentTimeMillis(), ThreadLocalRandom.current().nextInt(100, 1000))});
        request.setUserReference(userReference);
        return request;
    }

    public Job createMoveJob(MoveAttachmentRequest request) throws JobException {
        request.setCheckRights(true);
        request.setUserReference(this.documentAccessBridge.getCurrentUserReference());
        request.setAuthorReference(this.documentAccessBridge.getCurrentAuthorReference());
        return this.jobExecutor.execute("refactoring/attachment/move", (Request)request);
    }

    public boolean locationAvailable(DocumentReference documentReference, String attachmentName) {
        try {
            return this.attachmentsManager.available(new AttachmentReference(attachmentName, documentReference));
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to check if [{}] exists [{}]. Cause: [{}].", new Object[]{attachmentName, documentReference, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return false;
        }
    }

    public long backlinksCount(AttachmentReference attachmentReference) throws AttachmentException {
        XWikiContext xcontext = (XWikiContext)this.xWikiContextProvider.get();
        try {
            return xcontext.getWiki().getStore().loadBacklinks(attachmentReference, true, xcontext).size();
        }
        catch (XWikiException e) {
            throw new AttachmentException(String.format("Failed to get the backlinks for attachment [%s]", attachmentReference), e);
        }
    }

    @Unstable
    public AttachmentConfiguration getConfiguration() {
        return this.attachmentConfiguration;
    }
}

