/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.internal.listener;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.attachment.refactoring.MoveAttachmentRequest;
import org.xwiki.attachment.refactoring.event.AttachmentMovedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.RefactoringException;
import org.xwiki.refactoring.internal.ModelBridge;
import org.xwiki.refactoring.internal.ReferenceUpdater;
import org.xwiki.refactoring.internal.listener.LinkIndexingWaitingHelper;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
@Named(value="org.xwiki.attachment.internal.listener.MovedAttachmentListener")
public class MovedAttachmentListener
implements EventListener {
    public static final String HINT = "org.xwiki.attachment.internal.listener.MovedAttachmentListener";
    @Inject
    private ReferenceUpdater referenceUpdater;
    @Inject
    private JobProgressManager progressManager;
    @Inject
    private ModelBridge modelBridge;
    @Inject
    private AuthorizationManager authorization;
    @Inject
    private Logger logger;
    @Inject
    private Provider<LinkIndexingWaitingHelper> linkIndexingHelper;

    public String getName() {
        return HINT;
    }

    public List<Event> getEvents() {
        return Collections.singletonList(new AttachmentMovedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        AttachmentMovedEvent attachmentMovedEvent = (AttachmentMovedEvent)event;
        MoveAttachmentRequest moveAttachmentRequest = (MoveAttachmentRequest)((Object)data);
        if (moveAttachmentRequest.isUpdateReferences()) {
            Predicate<EntityReference> canEdit = reference -> !(moveAttachmentRequest.isCheckRights() && !this.authorization.hasAccess(Right.EDIT, moveAttachmentRequest.getUserReference(), reference) || moveAttachmentRequest.isCheckAuthorRights() && !this.authorization.hasAccess(Right.EDIT, moveAttachmentRequest.getAuthorReference(), reference));
            try {
                this.updateBackLinks(attachmentMovedEvent, canEdit);
            }
            catch (RefactoringException e) {
                this.logger.error("Failed to update backlinks targetting attachment [{}] for request [{}]", new Object[]{attachmentMovedEvent.getSourceReference(), moveAttachmentRequest.toString(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBackLinks(AttachmentMovedEvent event, Predicate<EntityReference> canEdit) throws RefactoringException {
        this.logger.info("Updating the back-links for attachment [{}].", (Object)event.getSourceReference());
        ((LinkIndexingWaitingHelper)this.linkIndexingHelper.get()).maybeWaitForLinkIndexingWithLog(10, TimeUnit.SECONDS);
        HashSet<DocumentReference> documentsList = new HashSet<DocumentReference>(this.modelBridge.getBackLinkedDocuments(event.getSourceReference()));
        documentsList.add(((AttachmentReference)event.getSourceReference()).getDocumentReference());
        this.progressManager.pushLevelProgress(documentsList.size(), (Object)this);
        try {
            for (DocumentReference backlinkDocumentReference : documentsList) {
                this.progressManager.startStep((Object)this);
                if (canEdit.test((EntityReference)backlinkDocumentReference)) {
                    this.referenceUpdater.update(backlinkDocumentReference, event.getSourceReference(), event.getTargetReference());
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }
}

