/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.internal.listener;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AttachmentAddedEvent;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.attachment.internal.AttachmentsManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="Attachment.Code.RedirectAttachmentClass")
public class AttachmentsListener
implements EventListener {
    @Inject
    private AttachmentsManager attachmentsManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;
    @Inject
    private Logger logger;

    public String getName() {
        return "Attachment.Code.RedirectAttachmentClass";
    }

    public List<Event> getEvents() {
        return Collections.singletonList(new AttachmentAddedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        AttachmentAddedEvent attachmentAddedEvent = (AttachmentAddedEvent)event;
        XWikiDocument doc = (XWikiDocument)source;
        if (this.attachmentsManager.removeExistingRedirection(attachmentAddedEvent.getName(), doc)) {
            try {
                String message = this.contextualLocalizationManager.getTranslationPlain("attachment.listener.attachmentAdded.removeRedirection", new Object[]{attachmentAddedEvent.getName()});
                ((XWikiContext)this.xcontextProvider.get()).getWiki().saveDocument(doc, message, true, (XWikiContext)this.xcontextProvider.get());
            }
            catch (XWikiException e) {
                this.logger.warn("Unable to remove deprecated attachment redirection object from [{}] for attachment [{}]. Cause: [{}].", new Object[]{doc, attachmentAddedEvent.getName(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }
}

