/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.redirection.RedirectionFilter;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.attachment.internal.AttachmentsManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.resource.ResourceReferenceManager;
import org.xwiki.resource.entity.EntityResourceReference;

@Component
@Singleton
@Named(value="Attachment.Code.RedirectAttachmentClass")
public class AttachmentsRedirectionFilter
implements RedirectionFilter {
    @Inject
    private ResourceReferenceManager resourceReferenceManager;
    @Inject
    private AttachmentsManager attachmentsManager;

    public boolean redirect(XWikiContext context) throws XWikiException {
        AttachmentReference attachmentReference;
        Optional<AttachmentReference> redirection;
        boolean redirect = false;
        if (Objects.equals(context.getAction(), "download") && (redirection = this.attachmentsManager.getRedirection(attachmentReference = this.getAttachmentReference())).isPresent()) {
            this.doRedirect(context, redirection.get());
            redirect = true;
        }
        return redirect;
    }

    private void doRedirect(XWikiContext context, AttachmentReference attachment) throws XWikiException {
        XWikiRequest request = context.getRequest();
        String url = context.getWiki().getURL((EntityReference)attachment, context.getAction(), request.getQueryString(), null, context);
        try {
            context.getResponse().sendRedirect(url);
        }
        catch (IOException e) {
            throw new XWikiException(String.format("Failed to redirect to attachment [%s].", attachment), (Throwable)e);
        }
    }

    private AttachmentReference getAttachmentReference() {
        EntityResourceReference entityResource = (EntityResourceReference)this.resourceReferenceManager.getResourceReference();
        return new AttachmentReference(entityResource.getEntityReference().extractReference(EntityType.ATTACHMENT));
    }
}

