/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal;

import com.xpn.xwiki.XWikiException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.Encoded;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.annotation.rest.internal.AbstractAnnotationRESTResource;
import org.xwiki.annotation.rest.model.jaxb.AnnotationField;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationResponse;
import org.xwiki.annotation.rest.model.jaxb.AnnotationUpdateRequest;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiRestException;

@Component
@Named(value="org.xwiki.annotation.rest.internal.SingleAnnotationRESTResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName: .+}/pages/{pageName}/annotation/{id}")
public class SingleAnnotationRESTResource
extends AbstractAnnotationRESTResource {
    @DELETE
    public AnnotationResponse doDelete(@PathParam(value="spaceName") @Encoded String spaceNames, @PathParam(value="pageName") String page, @PathParam(value="wikiName") String wiki, @PathParam(value="id") String id, AnnotationRequest request) throws XWikiRestException {
        try {
            DocumentReference documentReference = new DocumentReference(wiki, this.parseSpaceSegments(spaceNames), page);
            this.updateContext(documentReference);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (!this.annotationRightService.canEditAnnotation(id, documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.annotationService.removeAnnotation(documentName, id);
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, request);
            return response;
        }
        catch (XWikiException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return this.getErrorResponse(e);
        }
        catch (AnnotationServiceException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return this.getErrorResponse(e);
        }
    }

    @PUT
    public AnnotationResponse doUpdate(@PathParam(value="spaceName") @Encoded String spaceNames, @PathParam(value="pageName") String page, @PathParam(value="wikiName") String wiki, @PathParam(value="id") String id, AnnotationUpdateRequest updateRequest) throws XWikiRestException {
        try {
            DocumentReference documentReference = new DocumentReference(wiki, this.parseSpaceSegments(spaceNames), page);
            this.updateContext(documentReference);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (!this.annotationRightService.canEditAnnotation(id, documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Annotation newAnnotation = new Annotation(id);
            for (AnnotationField field : updateRequest.getAnnotation().getFields()) {
                newAnnotation.set(field.getName(), (Object)field.getValue());
            }
            Map<String, Object> annotationMetaData = this.getMap(updateRequest.getAnnotation());
            this.handleTemporaryUploadedFiles(documentReference, annotationMetaData);
            List<String> skippedFields = Arrays.asList("selection", "selectionLeftContext", "selectionRightContext", "originalSelection", "author", "state");
            for (Map.Entry<String, Object> field : annotationMetaData.entrySet()) {
                if (skippedFields.contains(field.getKey())) continue;
                newAnnotation.set(field.getKey(), field.getValue());
            }
            newAnnotation.setAuthor(this.getXWikiUser());
            this.annotationService.updateAnnotation(documentName, newAnnotation);
            this.cleanTemporaryUploadedFiles(documentReference);
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, updateRequest);
            return response;
        }
        catch (XWikiException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return this.getErrorResponse(e);
        }
        catch (AnnotationServiceException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return this.getErrorResponse(e);
        }
    }
}

