/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.io.internal.migration.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.DateProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.StringListProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.annotation.AnnotationConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;

@Component
@Named(value="R40001XWIKI7540")
@Singleton
public class R40001XWIKI7540DataMigration
extends AbstractHibernateDataMigration {
    private static final EntityReference XWIKI_COMMENT_CLASS_REFERENCE = new EntityReference("XWikiComments", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private static final EntityReference XWIKI_ANNOTATION_CLASS_REFERENCE = new EntityReference("AnnotationClass", EntityType.DOCUMENT, new EntityReference("AnnotationCode", EntityType.SPACE));
    @Inject
    protected Logger logger;
    @Inject
    protected EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    protected AnnotationConfiguration configuration;
    protected Map<DocumentReference, List<Map.Entry<Date, BaseObject>>> documentToDatedObjectsMap = new HashMap<DocumentReference, List<Map.Entry<Date, BaseObject>>>();
    protected Map<BaseObject, List<BaseProperty>> objectToPropertiesMap = new HashMap<BaseObject, List<BaseProperty>>();

    public String getDescription() {
        return "See https://jira.xwiki.org/browse/XWIKI-7540";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(40001);
    }

    protected boolean checkAnnotationsAndComments() throws DataMigrationException {
        XWikiContext context = this.getXWikiContext();
        String resultOfSkippingDatabase = "Comments and anotations will remain separated";
        try {
            DocumentReference currentAnnotationClassReference = this.configuration.getAnnotationClassReference();
            currentAnnotationClassReference = currentAnnotationClassReference.removeParent((EntityReference)new WikiReference(context.getWikiId()));
            if (!XWIKI_ANNOTATION_CLASS_REFERENCE.equals((Object)currentAnnotationClassReference)) {
                this.logger.warn("Skipping database [{}] because it uses a custom annotation class. {}", (Object)context.getWikiId(), (Object)resultOfSkippingDatabase);
                return false;
            }
            BaseClass commentsClass = context.getWiki().getCommentsClass(context);
            if (commentsClass.hasCustomMapping()) {
                this.logger.warn("Skipping database [{}] because it uses a custom mapping for comments. {}", (Object)context.getWikiId(), (Object)resultOfSkippingDatabase);
                return false;
            }
        }
        catch (Exception e) {
            String message = "Failed to check the current annotation and comments classes for customizations. Migration will not execute";
            this.logger.error(message, (Throwable)e);
            throw new DataMigrationException(message, (Throwable)e);
        }
        return true;
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        if (!this.checkAnnotationsAndComments()) {
            return;
        }
        this.documentToDatedObjectsMap.clear();
        this.objectToPropertiesMap.clear();
        this.logger.info("Computing the work to be done.");
        this.getStore().executeRead(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)new GetWorkToBeDoneHibernateCallback());
        this.logger.info("There is a total of {} documents to migrate.", (Object)this.documentToDatedObjectsMap.keySet().size());
        DoWorkOnDocumentHibernateCallback doWorkOnDocumentHibernateCallback = new DoWorkOnDocumentHibernateCallback();
        for (DocumentReference documentReference : this.documentToDatedObjectsMap.keySet()) {
            this.logger.info("Migrating document [{}]", this.referenceSerializer.serialize((EntityReference)documentReference, (Object[])null));
            doWorkOnDocumentHibernateCallback.setDocumentReference(documentReference);
            this.getStore().executeWrite(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)doWorkOnDocumentHibernateCallback);
        }
    }

    private final class GetWorkToBeDoneHibernateCallback
    implements XWikiHibernateBaseStore.HibernateCallback<Object> {
        private GetWorkToBeDoneHibernateCallback() {
        }

        public Object doInHibernate(Session session) throws HibernateException, XWikiException {
            try {
                Query getExistingAnnotationsAndCommentsQuery = session.createQuery("SELECT obj, prop FROM BaseObject obj, BaseProperty prop WHERE (obj.className='AnnotationCode.AnnotationClass' OR obj.className='XWiki.XWikiComments') AND prop.id.id=obj.id AND obj.name in (SELECT doc.fullName FROM XWikiDocument doc, BaseObject ann WHERE ann.name=doc.fullName AND ann.className='AnnotationCode.AnnotationClass')", Object[].class);
                List queryResults = getExistingAnnotationsAndCommentsQuery.list();
                this.preProcessResults(queryResults);
            }
            catch (Exception e) {
                throw new XWikiException(3, 3005, R40001XWIKI7540DataMigration.this.getName() + " failed to read the work to be done.", (Throwable)e);
            }
            return Boolean.TRUE;
        }

        private void preProcessResults(List<Object[]> queryResults) throws HibernateException {
            for (Object[] queryResult : queryResults) {
                List<BaseProperty> properties;
                BaseObject object = (BaseObject)queryResult[0];
                BaseProperty property = (BaseProperty)queryResult[1];
                DocumentReference documentReference = object.getDocumentReference();
                if (property instanceof DateProperty) {
                    List<Map.Entry<Date, BaseObject>> datedObjects = R40001XWIKI7540DataMigration.this.documentToDatedObjectsMap.get(documentReference);
                    if (datedObjects == null) {
                        datedObjects = new ArrayList<Map.Entry<Date, BaseObject>>();
                        R40001XWIKI7540DataMigration.this.documentToDatedObjectsMap.put(documentReference, datedObjects);
                    }
                    Date date = (Date)property.getValue();
                    AbstractMap.SimpleEntry<Date, BaseObject> datedObject = new AbstractMap.SimpleEntry<Date, BaseObject>(date, object);
                    datedObjects.add(datedObject);
                }
                if ((properties = R40001XWIKI7540DataMigration.this.objectToPropertiesMap.get(object)) == null) {
                    properties = new ArrayList<BaseProperty>();
                    R40001XWIKI7540DataMigration.this.objectToPropertiesMap.put(object, properties);
                }
                properties.add(property);
            }
        }
    }

    private final class DoWorkOnDocumentHibernateCallback
    implements XWikiHibernateBaseStore.HibernateCallback<Object> {
        private DocumentReference documentReference;
        private Map<BaseObject, BaseObject> oldToNewObjectMap;
        private Map<Integer, Integer> oldToNewCommentNumberMap;

        private DoWorkOnDocumentHibernateCallback() {
        }

        public void setDocumentReference(DocumentReference documentReference) {
            this.documentReference = documentReference;
            this.oldToNewObjectMap = new HashMap<BaseObject, BaseObject>();
            this.oldToNewCommentNumberMap = new HashMap<Integer, Integer>();
        }

        public Object doInHibernate(Session session) throws HibernateException, XWikiException {
            try {
                this.processObjects(session);
            }
            catch (Exception e) {
                throw new XWikiException(3, 3005, R40001XWIKI7540DataMigration.this.getName() + " failed to do the work for document " + (String)R40001XWIKI7540DataMigration.this.referenceSerializer.serialize((EntityReference)this.documentReference, (Object[])null), (Throwable)e);
            }
            return Boolean.TRUE;
        }

        private void processObjects(Session session) throws HibernateException {
            BaseObject newComment;
            BaseObject deletedObject;
            int newObjectNumber;
            List<Map.Entry<Date, BaseObject>> datedObjects = R40001XWIKI7540DataMigration.this.documentToDatedObjectsMap.get(this.documentReference);
            for (Map.Entry<Date, BaseObject> datedObject : datedObjects) {
                BaseObject object = datedObject.getValue();
                for (BaseProperty property : R40001XWIKI7540DataMigration.this.objectToPropertiesMap.get(object)) {
                    session.delete((Object)property);
                }
                session.delete((Object)object);
            }
            session.flush();
            session.clear();
            Collections.sort(datedObjects, new Comparator<Map.Entry<Date, BaseObject>>(){

                @Override
                public int compare(Map.Entry<Date, BaseObject> datedObject1, Map.Entry<Date, BaseObject> datedObject2) {
                    return datedObject1.getKey().compareTo(datedObject2.getKey());
                }
            });
            for (newObjectNumber = 0; newObjectNumber < datedObjects.size(); ++newObjectNumber) {
                deletedObject = datedObjects.get(newObjectNumber).getValue();
                newComment = this.getMigratedObject(deletedObject, newObjectNumber);
                if (deletedObject.getRelativeXClassReference().equals((Object)XWIKI_COMMENT_CLASS_REFERENCE)) {
                    this.oldToNewCommentNumberMap.put(deletedObject.getNumber(), newComment.getNumber());
                }
                this.oldToNewObjectMap.put(deletedObject, newComment);
                session.save((Object)newComment);
            }
            for (newObjectNumber = 0; newObjectNumber < datedObjects.size(); ++newObjectNumber) {
                deletedObject = datedObjects.get(newObjectNumber).getValue();
                newComment = this.oldToNewObjectMap.get(deletedObject);
                List<BaseProperty> deletedProperties = R40001XWIKI7540DataMigration.this.objectToPropertiesMap.get(deletedObject);
                for (BaseProperty deletedProperty : deletedProperties) {
                    BaseProperty newProperty = this.getMigratedProperty(deletedProperty, newComment);
                    session.save((Object)newProperty);
                }
            }
        }

        private BaseObject getMigratedObject(BaseObject deletedObject, int newObjectNumber) {
            BaseObject newObject = deletedObject.clone();
            newObject.setNumber(newObjectNumber);
            if (deletedObject.getRelativeXClassReference().equals((Object)XWIKI_ANNOTATION_CLASS_REFERENCE)) {
                newObject.setXClassReference(XWIKI_COMMENT_CLASS_REFERENCE);
            }
            return newObject;
        }

        private BaseProperty getMigratedProperty(BaseProperty deletedProperty, BaseObject newComment) {
            Object newProperty = null;
            if (deletedProperty instanceof StringListProperty) {
                StringListProperty stringListProperty = (StringListProperty)deletedProperty;
                newProperty = "author".equals(deletedProperty.getName()) ? new StringProperty() : new LargeStringProperty();
                String deletedPropertyValue = null;
                List internalListValue = stringListProperty.getList();
                if (!internalListValue.isEmpty()) {
                    deletedPropertyValue = (String)internalListValue.get(0);
                }
                newProperty.setValue(deletedPropertyValue);
                newProperty.setName(deletedProperty.getName());
            } else {
                newProperty = deletedProperty.clone();
            }
            newProperty.setId(newComment.getId());
            if ("annotation".equals(deletedProperty.getName())) {
                newProperty.setName("comment");
            } else if ("replyto".equals(deletedProperty.getName()) && deletedProperty.getValue() != null) {
                int oldValue = (Integer)deletedProperty.getValue();
                int newValue = this.oldToNewCommentNumberMap.get(oldValue);
                newProperty.setValue((Object)newValue);
            }
            return newProperty;
        }
    }
}

