/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal.renderer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.xwiki.annotation.internal.renderer.AnnotationGeneratorChainingListener;
import org.xwiki.annotation.internal.renderer.AnnotationMarkersXHTMLPrinter;
import org.xwiki.annotation.renderer.AnnotationEvent;
import org.xwiki.annotation.renderer.ChainingPrintRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.XHTMLChainingRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.chaining.EventType;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.xml.html.HTMLElementSanitizer;

public class AnnotationXHTMLChainingRenderer
extends XHTMLChainingRenderer
implements ChainingPrintRenderer {
    private Map<EventType, Integer> eventsCount = new HashMap<EventType, Integer>();
    private AnnotationMarkersXHTMLPrinter annotationsMarkerPrinter;

    public AnnotationXHTMLChainingRenderer(XHTMLLinkRenderer linkRenderer, XHTMLImageRenderer imageRenderer, HTMLElementSanitizer htmlElementSanitizer, ListenerChain listenerChain) {
        super(linkRenderer, imageRenderer, htmlElementSanitizer, listenerChain);
    }

    public AnnotationMarkersXHTMLPrinter getAnnotationsMarkerPrinter() {
        if (this.annotationsMarkerPrinter == null) {
            this.annotationsMarkerPrinter = new AnnotationMarkersXHTMLPrinter(this.getPrinter(), this.getHtmlElementSanitizer());
        }
        return this.annotationsMarkerPrinter;
    }

    protected XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.getAnnotationsMarkerPrinter();
    }

    protected AnnotationGeneratorChainingListener getAnnotationGenerator() {
        return (AnnotationGeneratorChainingListener)this.getListenerChain().getListener(AnnotationGeneratorChainingListener.class);
    }

    public void onWord(String word) {
        this.getAnnotationsMarkerPrinter().openAllAnnotationMarkers();
        SortedMap<Integer, List<AnnotationEvent>> annEvts = this.getAnnotationGenerator().getAnnotationEvents();
        if (annEvts != null && !annEvts.isEmpty()) {
            this.getAnnotationsMarkerPrinter().printXMLWithAnnotations(word, annEvts);
        } else {
            this.getXHTMLWikiPrinter().printXML(word);
        }
    }

    public void onSpace() {
        this.getAnnotationsMarkerPrinter().openAllAnnotationMarkers();
        super.onSpace();
    }

    public void onSpecialSymbol(char symbol) {
        this.getAnnotationsMarkerPrinter().openAllAnnotationMarkers();
        SortedMap<Integer, List<AnnotationEvent>> annEvts = this.getAnnotationGenerator().getAnnotationEvents();
        if (annEvts != null && !annEvts.isEmpty()) {
            this.getAnnotationsMarkerPrinter().printXMLWithAnnotations("" + symbol, annEvts);
        } else {
            this.getXHTMLWikiPrinter().printXML("" + symbol);
        }
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        SortedMap<Integer, List<AnnotationEvent>> annEvts = this.getAnnotationGenerator().getAnnotationEvents();
        if (inline) {
            String ttEltName = "tt";
            this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
            this.getXHTMLWikiPrinter().printXMLStartElement(ttEltName, (String[][])new String[][]{{"class", "wikimodel-verbatim"}});
            this.getAnnotationsMarkerPrinter().openAllAnnotationMarkers();
            if (annEvts != null && annEvts.size() > 0) {
                this.getAnnotationsMarkerPrinter().printXMLWithAnnotations(content, annEvts);
            } else {
                this.getXHTMLWikiPrinter().printXML(content);
            }
            this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
            this.getXHTMLWikiPrinter().printXMLEndElement(ttEltName);
        } else {
            String preEltName = "pre";
            this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
            this.getXHTMLWikiPrinter().printXMLStartElement(preEltName, parameters);
            this.getAnnotationsMarkerPrinter().openAllAnnotationMarkers();
            if (annEvts != null && annEvts.size() > 0) {
                this.getAnnotationsMarkerPrinter().printXMLWithAnnotations(content, annEvts);
            } else {
                this.getXHTMLWikiPrinter().printXML(content);
            }
            this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
            this.getXHTMLWikiPrinter().printXMLEndElement(preEltName);
        }
    }

    public void onRawText(String text, Syntax syntax) {
        SortedMap<Integer, List<AnnotationEvent>> currentBookmarks = this.getAnnotationGenerator().getAnnotationEvents();
        if (currentBookmarks != null) {
            for (Map.Entry<Integer, List<AnnotationEvent>> bookmark : currentBookmarks.entrySet()) {
                for (AnnotationEvent annEvt : bookmark.getValue()) {
                    if (annEvt.getType() != AnnotationEvent.AnnotationEventType.START) continue;
                    this.getAnnotationsMarkerPrinter().beginAnnotation(annEvt.getAnnotation());
                }
            }
        }
        this.getAnnotationsMarkerPrinter().openAllAnnotationMarkers();
        super.onRawText(text, syntax);
        if (currentBookmarks != null) {
            for (Map.Entry<Integer, List<AnnotationEvent>> bookmark : currentBookmarks.entrySet()) {
                for (AnnotationEvent annEvt : bookmark.getValue()) {
                    if (annEvt.getType() != AnnotationEvent.AnnotationEventType.END) continue;
                    this.getAnnotationsMarkerPrinter().endAnnotation(annEvt.getAnnotation());
                }
            }
        }
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endLink(reference, freestanding, parameters);
    }

    public void endDefinitionDescription() {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endDefinitionDescription();
    }

    public void endDefinitionList(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endDefinitionList(parameters);
    }

    public void endDefinitionTerm() {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endDefinitionTerm();
    }

    public void endDocument(MetaData metadata) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endDocument(metadata);
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endFormat(format, parameters);
    }

    public void endGroup(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endGroup(parameters);
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endHeader(level, id, parameters);
    }

    public void endList(ListType type, Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endList(type, parameters);
    }

    public void endListItem() {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endListItem();
    }

    public void endParagraph(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endParagraph(parameters);
    }

    public void endQuotation(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endQuotation(parameters);
    }

    public void endQuotationLine() {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endQuotationLine();
    }

    public void endSection(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endSection(parameters);
    }

    public void endTable(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endTable(parameters);
    }

    public void endTableCell(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endTableCell(parameters);
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endTableHeadCell(parameters);
    }

    public void endTableRow(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.endTableRow(parameters);
    }

    public void beginDefinitionDescription() {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginDefinitionDescription();
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginDefinitionList(parameters);
    }

    public void beginDefinitionTerm() {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginDefinitionTerm();
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginFormat(format, parameters);
    }

    public void beginGroup(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginGroup(parameters);
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginHeader(level, id, parameters);
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginLink(reference, freestanding, parameters);
    }

    public void beginList(ListType type, Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginList(type, parameters);
    }

    public void beginListItem() {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginListItem();
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginParagraph(parameters);
    }

    public void beginQuotation(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginQuotation(parameters);
    }

    public void beginQuotationLine() {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginQuotationLine();
    }

    public void beginSection(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginSection(parameters);
    }

    public void beginTable(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginTable(parameters);
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginTableCell(parameters);
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginTableHeadCell(parameters);
    }

    public void beginTableRow(Map<String, String> parameters) {
        this.getAnnotationsMarkerPrinter().closeAllAnnotationMarkers();
        super.beginTableRow(parameters);
    }

    protected int getAndIncrement(EventType type) {
        Integer currentCount = this.eventsCount.get(type);
        if (currentCount == null) {
            currentCount = 0;
        }
        this.eventsCount.put(type, currentCount + 1);
        return currentCount;
    }
}

