/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal.content;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.annotation.content.AlteredContent;
import org.xwiki.annotation.content.filter.Filter;
import org.xwiki.annotation.internal.content.AbstractContentAlterer;
import org.xwiki.annotation.internal.content.OffsetsMapAlteredContent;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="space-normalizer")
@Singleton
public class SpaceNormalizerContentAlterer
extends AbstractContentAlterer {
    @Inject
    @Named(value="whitespace")
    private Filter whitespaceFilter;

    @Override
    public AlteredContent alter(CharSequence sequence) {
        StringBuffer buffer = new StringBuffer();
        HashMap<Integer, Integer> initialToAltered = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> alteredToInitial = new HashMap<Integer, Integer>();
        int removedChars = 0;
        boolean isInWhitespace = true;
        for (int i = 0; i < sequence.length(); ++i) {
            boolean isWhitespace;
            Character c = Character.valueOf(sequence.charAt(i));
            boolean bl = isWhitespace = !this.whitespaceFilter.accept(c);
            if (!isWhitespace || isWhitespace && !isInWhitespace) {
                isInWhitespace = isWhitespace;
                buffer.append(isWhitespace ? " " : c);
                for (int t = 0; t <= removedChars; ++t) {
                    initialToAltered.put(i - t, buffer.length() - 1);
                }
                removedChars = 0;
                alteredToInitial.put(buffer.length() - 1, i);
                continue;
            }
            ++removedChars;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == ' ') {
            buffer.deleteCharAt(buffer.length() - 1);
            ++removedChars;
            alteredToInitial.remove(buffer.length());
        }
        if (buffer.length() > 0) {
            for (int t = 0; t < removedChars; ++t) {
                initialToAltered.put(sequence.length() - 1 - t, buffer.length() - 1 - 1);
            }
        }
        return new OffsetsMapAlteredContent(buffer.toString(), sequence.length(), initialToAltered, alteredToInitial);
    }
}

